/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.jdt.internal.core.util;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.manifest.core.BundleManifestUtils;
import org.eclipse.virgo.ide.manifest.internal.core.model.BundleManifest;
import org.eclipse.virgo.ide.manifest.internal.core.model.BundleManifestHeader;
import org.eclipse.virgo.kernel.osgi.provisioning.tools.DependencyLocationException;
import org.eclipse.virgo.kernel.osgi.provisioning.tools.ImportDescriptor;

public class MarkerUtils {
    public static void removeErrorMarkers(IJavaProject javaProject, boolean testBundle) {
        IFile manifest = BundleManifestUtils.locateManifest((IJavaProject)javaProject, (boolean)testBundle);
        try {
            manifest.deleteMarkers("org.eclipse.virgo.ide.jdt.core.dependencyproblemmarker", true, 2);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "org.eclipse.virgo.ide.jdt.core");
        }
    }

    public static void createErrorMarkers(final DependencyLocationException e, final IJavaProject javaProject, final boolean testBundle) {
        IFile manifest = BundleManifestUtils.locateManifest((IJavaProject)javaProject, (boolean)testBundle);
        if (manifest == null) {
            return;
        }
        final BundleManifest bundleManifest = new BundleManifest(manifest);
        final IDocument document = bundleManifest.getDocument();
        Job markerCreationJob = new Job("Managing markers on resource '" + manifest.getFullPath().toString() + "'", (IResource)manifest){
            private final /* synthetic */ IResource val$manifest;
            {
                this.val$manifest = iResource;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                int lineNumber;
                ImportDescriptor desc;
                int n;
                int n2;
                ImportDescriptor[] importDescriptorArray;
                MarkerUtils.removeErrorMarkers(javaProject, testBundle);
                if (e == null) {
                    return Status.OK_STATUS;
                }
                if (e.getUnsatisfiablePackageImports() != null) {
                    importDescriptorArray = e.getUnsatisfiablePackageImports();
                    n2 = importDescriptorArray.length;
                    n = 0;
                    while (n < n2) {
                        desc = importDescriptorArray[n];
                        lineNumber = BundleManifestUtils.getLineNumber((IDocument)document, (BundleManifestHeader)bundleManifest.getHeader("Import-Package"), (String)desc.getName());
                        MarkerUtils.createProblemMarker(this.val$manifest, "missing_dependency_import_package", desc.getName(), desc.getParseVersion(), "Import-Package: " + desc.getName() + " " + desc.getVersion() + " could not be resolved", lineNumber, 2);
                        ++n;
                    }
                }
                if (e.getUnsatisfiableLibraryImports() != null) {
                    importDescriptorArray = e.getUnsatisfiableLibraryImports();
                    n2 = importDescriptorArray.length;
                    n = 0;
                    while (n < n2) {
                        desc = importDescriptorArray[n];
                        lineNumber = BundleManifestUtils.getLineNumber((IDocument)document, (BundleManifestHeader)bundleManifest.getHeader("Import-Library"), (String)desc.getName());
                        MarkerUtils.createProblemMarker(this.val$manifest, "missing_dependency_import_library", desc.getName(), desc.getParseVersion(), "Import-Library: " + desc.getName() + " " + desc.getVersion() + " could not be resolved", lineNumber, 2);
                        ++n;
                    }
                }
                if (e.getUnsatisfiableRequireBundle() != null) {
                    importDescriptorArray = e.getUnsatisfiableRequireBundle();
                    n2 = importDescriptorArray.length;
                    n = 0;
                    while (n < n2) {
                        desc = importDescriptorArray[n];
                        lineNumber = BundleManifestUtils.getLineNumber((IDocument)document, (BundleManifestHeader)bundleManifest.getHeader("Require-Bundle"), (String)desc.getName());
                        MarkerUtils.createProblemMarker(this.val$manifest, "missing_dependency_require_bundle", desc.getName(), desc.getParseVersion(), "Require-Bundle: " + desc.getName() + " " + desc.getVersion() + " could not be resolved", lineNumber, 2);
                        ++n;
                    }
                }
                if (e.getUnsatisfiableBundleImports() != null) {
                    importDescriptorArray = e.getUnsatisfiableBundleImports();
                    n2 = importDescriptorArray.length;
                    n = 0;
                    while (n < n2) {
                        desc = importDescriptorArray[n];
                        lineNumber = BundleManifestUtils.getLineNumber((IDocument)document, (BundleManifestHeader)bundleManifest.getHeader("Import-Bundle"), (String)desc.getName());
                        MarkerUtils.createProblemMarker(this.val$manifest, "missing_dependency_import_bundle", desc.getName(), desc.getParseVersion(), "Import-Bundle: " + desc.getName() + " " + desc.getVersion() + " could not be resolved", lineNumber, 2);
                        ++n;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        markerCreationJob.setPriority(40);
        markerCreationJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        markerCreationJob.schedule();
    }

    public static void createProblemMarker(IResource resource, String message, int lineNumber, int severity) {
        MarkerUtils.createProblemMarker(resource, null, null, null, message, lineNumber, severity);
    }

    public static void createProblemMarker(IResource resource, String missingDependencyKind, String missingDependency, String missingDependencyVersion, String message, int lineNumber, int severity) {
        if (resource != null && resource.isAccessible()) {
            try {
                IMarker marker;
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = resource.findMarkers("org.eclipse.virgo.ide.jdt.core.dependencyproblemmarker", false, 0);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    String msg;
                    marker = iMarkerArray[n2];
                    int line = marker.getAttribute("lineNumber", -1);
                    if (line == lineNumber && (msg = marker.getAttribute("message", "")).equals(message)) {
                        return;
                    }
                    ++n2;
                }
                marker = resource.createMarker("org.eclipse.virgo.ide.jdt.core.dependencyproblemmarker");
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("message", message);
                attributes.put("severity", severity);
                attributes.put("lineNumber", lineNumber);
                if (missingDependency != null) {
                    attributes.put("missing_dependency_key", missingDependency);
                }
                if (missingDependencyVersion != null) {
                    attributes.put("missing_dependency_version_key", missingDependencyVersion);
                }
                if (missingDependencyKind != null) {
                    attributes.put("missing_dependency_kind_key", missingDependencyKind);
                }
                marker.setAttributes(attributes);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.jdt.core", "Couldn't create problem markers", (Throwable)e));
            }
        }
    }
}

