/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.properties;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractSectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.AbstractTabDescriptor;
import org.eclipse.ui.views.properties.tabbed.AdvancedPropertySection;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;

public class QueryResultTreeTabDescriptorProvider
implements ITabDescriptorProvider {
    private static final String QUERY_RESULT_PROPERTIES_CATEGORY = "org.eclipse.viatra.query.tooling.ui.result.propertiesCategory";
    private static final String QUERY_TAB_ID = "org.eclipse.viatra.query.tooling.ui.properties.query";
    private static final String MATCHER_TAB_ID = "org.eclipse.viatra.query.tooling.ui.properties.matcher";
    private static final String MATCH_TAB_ID = "org.eclipse.viatra.query.tooling.ui.properties.match";
    private static final String ADVANCED_TAB_ID = "org.eclipse.viatra.query.tooling.ui.properties.advanced";
    private AbstractTabDescriptor queryTabDescriptor;
    private AbstractTabDescriptor matcherTabDescriptor;
    private AbstractTabDescriptor matchTabDescriptor = new AbstractTabDescriptor(){

        public String getLabel() {
            return "Match";
        }

        public String getId() {
            return QueryResultTreeTabDescriptorProvider.MATCH_TAB_ID;
        }

        public String getCategory() {
            return QueryResultTreeTabDescriptorProvider.QUERY_RESULT_PROPERTIES_CATEGORY;
        }

        public List getSectionDescriptors() {
            ArrayList sections = Lists.newArrayList();
            sections.add(new AdvancedSectionDescriptor(PropertyKind.MATCH));
            return sections;
        }
    };
    private AbstractTabDescriptor advancedTabDescriptor;

    public QueryResultTreeTabDescriptorProvider() {
        this.matcherTabDescriptor = new AbstractTabDescriptor(){

            public String getLabel() {
                return "Matcher";
            }

            public String getId() {
                return QueryResultTreeTabDescriptorProvider.MATCHER_TAB_ID;
            }

            public String getCategory() {
                return QueryResultTreeTabDescriptorProvider.QUERY_RESULT_PROPERTIES_CATEGORY;
            }

            public List getSectionDescriptors() {
                ArrayList sections = Lists.newArrayList();
                sections.add(new AdvancedSectionDescriptor(PropertyKind.MATCHER));
                return sections;
            }
        };
        this.queryTabDescriptor = new AbstractTabDescriptor(){

            public String getLabel() {
                return "Query";
            }

            public String getId() {
                return QueryResultTreeTabDescriptorProvider.QUERY_TAB_ID;
            }

            public String getCategory() {
                return QueryResultTreeTabDescriptorProvider.QUERY_RESULT_PROPERTIES_CATEGORY;
            }

            public List getSectionDescriptors() {
                ArrayList sections = Lists.newArrayList();
                sections.add(new AdvancedSectionDescriptor(PropertyKind.QUERY));
                return sections;
            }
        };
        this.advancedTabDescriptor = new AbstractTabDescriptor(){

            public String getLabel() {
                return "Advanced";
            }

            public String getId() {
                return QueryResultTreeTabDescriptorProvider.ADVANCED_TAB_ID;
            }

            public String getCategory() {
                return QueryResultTreeTabDescriptorProvider.QUERY_RESULT_PROPERTIES_CATEGORY;
            }

            public List getSectionDescriptors() {
                ArrayList sections = Lists.newArrayList();
                sections.add(new AdvancedSectionDescriptor(PropertyKind.ADVANCED));
                return sections;
            }
        };
    }

    public ITabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        ArrayList descriptors = Lists.newArrayList();
        if (selection instanceof StructuredSelection) {
            Object firstElement = ((StructuredSelection)selection).getFirstElement();
            if (firstElement instanceof IPatternMatch) {
                descriptors.add(this.matchTabDescriptor);
                descriptors.add(this.matcherTabDescriptor);
                descriptors.add(this.queryTabDescriptor);
            } else if (firstElement instanceof QueryResultTreeMatcher) {
                descriptors.add(this.matcherTabDescriptor);
                descriptors.add(this.queryTabDescriptor);
            } else {
                descriptors.add(this.advancedTabDescriptor);
            }
        }
        return descriptors.toArray(new ITabDescriptor[0]);
    }

    private final class AdvancedSectionDescriptor
    extends AbstractSectionDescriptor {
        private PropertyKind kind;

        public AdvancedSectionDescriptor(PropertyKind kind) {
            this.kind = kind;
        }

        public String getTargetTab() {
            switch (this.kind) {
                case MATCH: {
                    return QueryResultTreeTabDescriptorProvider.MATCH_TAB_ID;
                }
                case MATCHER: {
                    return QueryResultTreeTabDescriptorProvider.MATCHER_TAB_ID;
                }
                case QUERY: {
                    return QueryResultTreeTabDescriptorProvider.QUERY_TAB_ID;
                }
                case ADVANCED: {
                    return QueryResultTreeTabDescriptorProvider.ADVANCED_TAB_ID;
                }
            }
            return null;
        }

        public ISection getSectionClass() {
            return new QueryResultPropertySection(this.kind);
        }

        public String getId() {
            return QueryResultPropertySection.class.getName();
        }
    }

    private static enum PropertyKind {
        MATCH,
        MATCHER,
        QUERY,
        ADVANCED;

    }

    private final class QueryResultPropertySection
    extends AdvancedPropertySection {
        private PropertyKind kind;

        public QueryResultPropertySection(PropertyKind kind) {
            this.kind = kind;
        }

        public void setInput(IWorkbenchPart part, ISelection selection) {
            Object firstElement;
            TreeSelection treeSelection;
            TreePath[] treePaths;
            if (selection instanceof TreeSelection && (treePaths = (treeSelection = (TreeSelection)selection).getPathsFor(firstElement = treeSelection.getFirstElement())).length == 1) {
                TreePath treePath = treePaths[0];
                if (firstElement instanceof IPatternMatch) {
                    TreePath parentPath = treePath.getParentPath();
                    TreeSelection matcherSelection = new TreeSelection(parentPath);
                    if (this.kind == PropertyKind.MATCHER) {
                        super.setInput(part, (ISelection)matcherSelection);
                        return;
                    }
                    if (this.kind == PropertyKind.QUERY) {
                        this.setInput(part, (ISelection)matcherSelection);
                        return;
                    }
                } else if (firstElement instanceof QueryResultTreeMatcher && this.kind == PropertyKind.QUERY) {
                    IQuerySpecificationRegistryEntry entry = ((QueryResultTreeMatcher)firstElement).getEntry();
                    StructuredSelection structuredSelection = new StructuredSelection((Object)entry);
                    super.setInput(part, (ISelection)structuredSelection);
                    return;
                }
            }
            super.setInput(part, selection);
        }
    }
}

