/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.util;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.viatra.query.patternlanguage.emf.util.IExpectedPackageNameProvider;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

public class JavaProjectExpectedPackageNameProvider
implements IExpectedPackageNameProvider {
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private Logger logger;

    public String getExpectedPackageName(PatternModel model) {
        URI fileURI = model.eResource().getURI();
        for (Pair storage : this.storage2UriMapper.getStorages(fileURI)) {
            if (!(storage.getFirst() instanceof IFile)) continue;
            IPath fileWorkspacePath = ((IStorage)storage.getFirst()).getFullPath();
            IJavaProject javaProject = JavaCore.create((IProject)((IProject)storage.getSecond()));
            if (javaProject == null || !javaProject.exists() || !javaProject.isOpen()) continue;
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath sourceFolderPath;
                    IResource resource;
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (!root.isArchive() && !root.isExternal() && (resource = root.getResource()) != null && (sourceFolderPath = resource.getFullPath()).isPrefixOf(fileWorkspacePath)) {
                        IPath classpathRelativePath = fileWorkspacePath.makeRelativeTo(sourceFolderPath);
                        return classpathRelativePath.removeLastSegments(1).toString().replace("/", ".");
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                this.logger.error((Object)"Error resolving package declaration for Pattern Model", (Throwable)e);
            }
        }
        return null;
    }
}

