/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch;

import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.nobase.ScopeCheck;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlan;

public final class ExecutionLoggerAdapter
implements ILocalSearchAdapter {
    volatile String indentation = "";
    private final Consumer<String> outputConsumer;

    public ExecutionLoggerAdapter(Consumer<String> outputConsumer) {
        this.outputConsumer = outputConsumer;
    }

    private void logMessage(String message) {
        this.outputConsumer.accept(message);
    }

    private void logMessage(String message, Object ... args) {
        this.outputConsumer.accept(String.format(message, args));
    }

    @Override
    public void patternMatchingStarted(LocalSearchMatcher lsMatcher) {
        this.logMessage(this.indentation + "[ START] " + lsMatcher.getQuerySpecification().getFullyQualifiedName());
    }

    @Override
    public void noMoreMatchesAvailable(LocalSearchMatcher lsMatcher) {
        this.logMessage(this.indentation + "[FINISH] " + lsMatcher.getQuerySpecification().getFullyQualifiedName());
    }

    @Override
    public void planChanged(Optional<SearchPlan> oldPlan, Optional<SearchPlan> newPlan) {
        this.logMessage(this.indentation + "[  PLAN] " + newPlan.map(p -> p.getSourceBody().getPattern().getFullyQualifiedName()).orElse(""));
        this.logMessage(this.indentation + newPlan.map(SearchPlan::toString).map(s -> s.replace("\n", "\n" + this.indentation)).orElse(""));
    }

    @Override
    public void operationSelected(SearchPlan plan, ISearchOperation operation, MatchingFrame frame, boolean isBacktrack) {
        String category = isBacktrack ? "[  BACK] " : "[SELECT] ";
        this.logMessage(this.indentation + category + operation.toString());
        if (operation instanceof IPatternMatcherOperation) {
            this.indentation = String.valueOf(this.indentation) + "\t";
        }
    }

    @Override
    public void operationExecuted(SearchPlan plan, ISearchOperation operation, MatchingFrame frame, boolean isSuccessful) {
        if (operation instanceof ScopeCheck) {
            return;
        }
        if (operation instanceof IPatternMatcherOperation && this.indentation.length() > 0) {
            this.indentation = this.indentation.substring(1);
        }
        this.logMessage(this.indentation + "[    %s] %s %s", isSuccessful ? "OK" : "NO", operation.toString(), frame.toString());
    }

    @Override
    public void matchFound(SearchPlan plan, MatchingFrame frame) {
        this.logMessage(this.indentation + "[ MATCH] " + plan.getSourceBody().getPattern().getFullyQualifiedName() + " " + frame.toString());
    }

    @Override
    public void duplicateMatchFound(MatchingFrame frame) {
        this.logMessage(this.indentation + "[ DUPL.] " + frame.toString());
    }
}

