/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.integration.zest.viewer.internal;

import org.eclipse.viatra.integration.zest.viewer.IGraphEdgeContentProvider;
import org.eclipse.zest.core.viewers.internal.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.internal.AbstractStylingModelFactory;
import org.eclipse.zest.core.widgets.Graph;

public class GraphModelEdgeFactory
extends AbstractStylingModelFactory {
    public GraphModelEdgeFactory(AbstractStructuredGraphViewer viewer) {
        super(viewer);
        if (!(viewer.getContentProvider() instanceof IGraphEdgeContentProvider)) {
            throw new IllegalArgumentException("Expected IGraphEdgeRelationshipContentProvider");
        }
    }

    public Graph createGraphModel(Graph model) {
        this.doBuildGraph(model);
        return model;
    }

    protected void doBuildGraph(Graph model) {
        super.doBuildGraph(model);
        Object[] nodes = this.getContentProvider().getElements(this.getViewer().getInput());
        nodes = this.filter(this.getViewer().getInput(), nodes);
        this.createModelNodes(model, nodes);
        this.createModelRelationships(model);
    }

    private void createModelRelationships(Graph model) {
        IGraphEdgeContentProvider content = this.getCastedContent();
        Object[] objectArray = content.getRelationships(this.getViewer().getInput());
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object relationship = objectArray[n2];
            Object source = content.getSource(relationship);
            Object target = content.getDestination(relationship);
            this.createConnection(model, relationship, source, target);
            ++n2;
        }
    }

    private void createModelNodes(Graph model, Object[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            this.createNode(model, nodes[i]);
            ++i;
        }
    }

    public void refresh(Graph graph, Object element) {
        this.refresh(graph, element, false);
    }

    public void refresh(Graph graph, Object element, boolean updateLabels) {
        this.refreshGraph(graph);
    }

    private IGraphEdgeContentProvider getCastedContent() {
        return (IGraphEdgeContentProvider)this.getContentProvider();
    }
}

