/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.InstanceListener;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperImpl;
import org.eclipse.viatra.query.runtime.base.exception.ViatraBaseException;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class EMFBaseIndexMetaStore {
    private static final EClass EOBJECT_CLASS = EcorePackage.eINSTANCE.getEObject();
    private final boolean isDynamicModel;
    private NavigationHelperImpl navigationHelper;
    private final Set<EPackage> knownPackages = new HashSet<EPackage>();
    private final Set<EClassifier> knownClassifiers = new HashSet<EClassifier>();
    private final Set<EStructuralFeature> knownFeatures = new HashSet<EStructuralFeature>();
    private final Map<Object, Set<Object>> subTypeMap = new HashMap<Object, Set<Object>>();
    private final Map<Object, Set<Object>> superTypeMap = new HashMap<Object, Set<Object>>();
    private final IMultiLookup<String, EPackage> uniqueIDToPackage = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.SETS, Object.class);
    private final Map<EClassifier, String> uniqueIDFromClassifier = new HashMap<EClassifier, String>();
    private final Map<ETypedElement, String> uniqueIDFromTypedElement = new HashMap<ETypedElement, String>();
    private final Map<Enumerator, String> uniqueIDFromEnumerator = new HashMap<Enumerator, String>();
    private final IMultiLookup<String, EClassifier> uniqueIDToClassifier = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.SETS, Object.class);
    private final IMultiLookup<String, ETypedElement> uniqueIDToTypedElement = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.SETS, Object.class);
    private final IMultiLookup<String, Enumerator> uniqueIDToEnumerator = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.SETS, Object.class);
    private final Map<String, Enumerator> uniqueIDToCanonicalEnumerator = new HashMap<String, Enumerator>();
    private Map<Class<?>, EEnum> generatedEENumClasses = new HashMap();
    private Object eObjectClassKey = null;

    public EMFBaseIndexMetaStore(NavigationHelperImpl navigationHelper) {
        this.navigationHelper = navigationHelper;
        BaseIndexOptions options = navigationHelper.getBaseIndexOptions();
        this.isDynamicModel = options.isDynamicEMFMode();
    }

    public Object getEObjectClassKey() {
        if (this.eObjectClassKey == null) {
            this.eObjectClassKey = this.toKey((EClassifier)EOBJECT_CLASS);
        }
        return this.eObjectClassKey;
    }

    protected Object toKey(EClassifier classifier) {
        if (this.isDynamicModel) {
            return this.toKeyDynamicInternal(classifier);
        }
        this.maintainMetamodel(classifier);
        return classifier;
    }

    protected String toKeyDynamicInternal(EClassifier classifier) {
        String id = this.uniqueIDFromClassifier.get(classifier);
        if (id == null) {
            Preconditions.checkArgument((!classifier.eIsProxy() ? 1 : 0) != 0, (String)"Classifier %s is an unresolved proxy", (Object[])new Object[]{classifier});
            id = String.valueOf(classifier.getEPackage().getNsURI()) + "##" + classifier.getName();
            this.uniqueIDFromClassifier.put(classifier, id);
            this.uniqueIDToClassifier.addPair((Object)id, (Object)classifier);
            this.maintainMetamodel(classifier);
        }
        return id;
    }

    protected String enumToKeyDynamicInternal(Enumerator enumerator) {
        String id = this.uniqueIDFromEnumerator.get(enumerator);
        if (id == null) {
            if (enumerator instanceof EEnumLiteral) {
                EEnumLiteral enumLiteral = (EEnumLiteral)enumerator;
                EEnum eEnum = enumLiteral.getEEnum();
                this.maintainMetamodel((EClassifier)eEnum);
                id = this.constructEnumID(eEnum.getEPackage().getNsURI(), eEnum.getName(), enumLiteral.getLiteral());
                Enumerator instanceEnum = enumLiteral.getInstance();
                if (instanceEnum != null && !this.uniqueIDToCanonicalEnumerator.containsKey(id)) {
                    this.uniqueIDToCanonicalEnumerator.put(id, instanceEnum);
                }
            } else {
                EEnum eEnum = this.generatedEENumClasses.get(enumerator.getClass());
                id = eEnum != null ? this.constructEnumID(eEnum.getEPackage().getNsURI(), eEnum.getName(), enumerator.getLiteral()) : this.constructEnumID("unkownPackage URI", enumerator.getClass().getSimpleName(), enumerator.getLiteral());
                if (!this.uniqueIDToCanonicalEnumerator.containsKey(id)) {
                    this.uniqueIDToCanonicalEnumerator.put(id, enumerator);
                }
            }
            this.uniqueIDFromEnumerator.put(enumerator, id);
            this.uniqueIDToEnumerator.addPair((Object)id, (Object)enumerator);
        }
        return id;
    }

    protected String constructEnumID(String nsURI, String name, String literal) {
        return String.format("%s##%s##%s", nsURI, name, literal);
    }

    protected Object toKey(EStructuralFeature feature) {
        if (this.isDynamicModel) {
            String id = this.uniqueIDFromTypedElement.get(feature);
            if (id == null) {
                Preconditions.checkArgument((!feature.eIsProxy() ? 1 : 0) != 0, (String)"Element %s is an unresolved proxy", (Object[])new Object[]{feature});
                id = String.valueOf(this.toKeyDynamicInternal((EClassifier)feature.eContainer())) + "##" + feature.getEType().getName() + "##" + feature.getName();
                this.uniqueIDFromTypedElement.put((ETypedElement)feature, id);
                this.uniqueIDToTypedElement.addPair((Object)id, (Object)feature);
                this.maintainMetamodel(feature);
            }
            return id;
        }
        this.maintainMetamodel(feature);
        return feature;
    }

    protected Enumerator enumToCanonicalDynamicInternal(Enumerator value) {
        String key = this.enumToKeyDynamicInternal(value);
        Enumerator canonicalEnumerator = this.uniqueIDToCanonicalEnumerator.computeIfAbsent(key, k -> (Enumerator)this.uniqueIDToEnumerator.lookup(k).iterator().next());
        return canonicalEnumerator;
    }

    protected Object toInternalValueRepresentation(Object value) {
        if (this.isDynamicModel) {
            if (value instanceof Enumerator) {
                return this.enumToCanonicalDynamicInternal((Enumerator)value);
            }
            return value;
        }
        return value;
    }

    protected void maintainMetamodel(EStructuralFeature feature) {
        if (!this.knownFeatures.contains(feature)) {
            this.knownFeatures.add(feature);
            this.maintainMetamodel((EClassifier)feature.getEContainingClass());
            this.maintainMetamodel(feature.getEType());
        }
    }

    protected void maintainMetamodel(EClassifier classifier) {
        if (!this.knownClassifiers.contains(classifier)) {
            this.checkEPackage(classifier);
            this.knownClassifiers.add(classifier);
            if (classifier instanceof EClass) {
                EClass clazz = (EClass)classifier;
                Object clazzKey = this.toKey((EClassifier)clazz);
                for (EClass superType : clazz.getEAllSuperTypes()) {
                    this.maintainTypeHierarhyInternal(clazzKey, this.toKey((EClassifier)superType));
                }
                this.maintainTypeHierarhyInternal(clazzKey, this.getEObjectClassKey());
            } else if (classifier instanceof EEnum) {
                EEnum eEnum = (EEnum)classifier;
                if (this.isDynamicModel) {
                    if (eEnum.getInstanceClass() != null) {
                        this.generatedEENumClasses.put(eEnum.getInstanceClass(), eEnum);
                    }
                    for (EEnumLiteral eEnumLiteral : eEnum.getELiterals()) {
                        this.enumToKeyDynamicInternal((Enumerator)eEnumLiteral);
                    }
                }
            }
        }
    }

    protected void checkEPackage(EClassifier classifier) {
        String nsURI;
        IMemoryView packagesOfURI;
        EPackage ePackage = classifier.getEPackage();
        if (this.knownPackages.add(ePackage) && !(packagesOfURI = this.uniqueIDToPackage.lookupOrEmpty((Object)(nsURI = ePackage.getNsURI()))).containsNonZero((Object)ePackage)) {
            this.uniqueIDToPackage.addPair((Object)nsURI, (Object)ePackage);
            if (!this.isDynamicModel && packagesOfURI.size() == 2) {
                this.navigationHelper.processingError((Throwable)((Object)new ViatraBaseException("NsURI (" + nsURI + ") collision detected between different instances of EPackages. If this is normal, try using dynamic EMF mode.")), "process new metamodel elements.");
            }
        }
    }

    protected void maintainTypeHierarhyInternal(Object subClassKey, Object superClassKey) {
        Map<Object, Map<InstanceListener, Set<EClass>>> instanceListeners;
        Map<Object, IndexingLevel> allObservedClasses = this.navigationHelper.getAllObservedClassesInternal();
        if (allObservedClasses.containsKey(superClassKey)) {
            allObservedClasses.put(subClassKey, allObservedClasses.get(superClassKey));
        }
        if ((instanceListeners = this.navigationHelper.peekInstanceListeners()) != null) {
            for (Map.Entry entry : instanceListeners.getOrDefault(superClassKey, Collections.emptyMap()).entrySet()) {
                InstanceListener listener = (InstanceListener)entry.getKey();
                for (EClass subscriptionType : (Set)entry.getValue()) {
                    this.navigationHelper.addInstanceListenerInternal(listener, subscriptionType, subClassKey);
                }
            }
        }
        Set subTypes = this.subTypeMap.computeIfAbsent(superClassKey, k -> new HashSet());
        subTypes.add(subClassKey);
        Set superTypes = this.superTypeMap.computeIfAbsent(subClassKey, k -> new HashSet());
        superTypes.add(superClassKey);
    }

    protected Map<Object, Set<Object>> getSubTypeMap() {
        return this.subTypeMap;
    }

    protected Map<Object, Set<Object>> getSuperTypeMap() {
        return this.superTypeMap;
    }

    public EStructuralFeature getKnownFeature(String featureId) {
        ETypedElement next;
        IMemoryView features = this.uniqueIDToTypedElement.lookup((Object)featureId);
        if (features != null && !features.isEmpty() && (next = (ETypedElement)features.iterator().next()) instanceof EStructuralFeature) {
            return (EStructuralFeature)next;
        }
        return null;
    }

    public EStructuralFeature getKnownFeatureForKey(Object featureKey) {
        EStructuralFeature feature = this.isDynamicModel ? this.getKnownFeature((String)featureKey) : (EStructuralFeature)featureKey;
        return feature;
    }

    public EClassifier getKnownClassifier(String key) {
        IMemoryView classifiersOfThisID = this.uniqueIDToClassifier.lookup((Object)key);
        if (classifiersOfThisID != null && !classifiersOfThisID.isEmpty()) {
            return (EClassifier)classifiersOfThisID.iterator().next();
        }
        return null;
    }

    public EClassifier getKnownClassifierForKey(Object classifierKey) {
        EClassifier cls = this.isDynamicModel ? this.getKnownClassifier((String)classifierKey) : (EClassifier)classifierKey;
        return cls;
    }
}

