/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.ITypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.TypeJudgement;
import org.eclipse.viatra.query.runtime.matchers.psystem.VariableDeferredPConstraint;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class TypeFilterConstraint
extends VariableDeferredPConstraint
implements ITypeConstraint {
    private Tuple variablesTuple;
    private IInputKey inputKey;
    private TypeJudgement equivalentJudgement;

    public TypeFilterConstraint(PBody pBody, Tuple variablesTuple, IInputKey inputKey) {
        super(pBody, variablesTuple.getDistinctElements());
        this.equivalentJudgement = new TypeJudgement(inputKey, variablesTuple);
        this.variablesTuple = variablesTuple;
        this.inputKey = inputKey;
        if (variablesTuple.getSize() != inputKey.getArity()) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " applied for variable tuple " + variablesTuple + " having wrong arity for input key " + inputKey);
        }
    }

    public Tuple getVariablesTuple() {
        return this.variablesTuple;
    }

    public IInputKey getInputKey() {
        return this.inputKey;
    }

    @Override
    public TypeJudgement getEquivalentJudgement() {
        return this.equivalentJudgement;
    }

    @Override
    protected void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        this.variablesTuple = this.variablesTuple.replaceAll(obsolete, replacement);
        this.equivalentJudgement = new TypeJudgement(this.inputKey, this.variablesTuple);
    }

    @Override
    public Set<TypeJudgement> getImpliedJudgements(IQueryMetaContext context) {
        return Collections.singleton(this.equivalentJudgement);
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return Collections.emptySet();
    }

    @Override
    public Set<PVariable> getDeferringVariables() {
        return this.getAffectedVariables();
    }

    @Override
    protected String toStringRest() {
        return String.valueOf(this.inputKey.getPrettyPrintableName()) + "@" + this.variablesTuple;
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies(IQueryMetaContext context) {
        return ITypeConstraint.TypeConstraintUtil.getFunctionalDependencies(context, this.inputKey, this.variablesTuple);
    }
}

