/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Iterator;
import java.util.List;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.IModifiableTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileModifiableMaskedTuple;

public class ExtendPositivePatternCall
implements ISearchOperation,
IPatternMatcherOperation {
    private final CallInformation information;
    private final VolatileModifiableMaskedTuple maskedTuple;
    private Iterator<? extends Tuple> matches = null;

    public ExtendPositivePatternCall(CallInformation information) {
        this.information = information;
        this.maskedTuple = new VolatileModifiableMaskedTuple(information.getThinFrameMask());
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        this.maskedTuple.updateTuple((IModifiableTuple)frame);
        IQueryResultProvider matcher = context.getMatcher(this.information.getReference());
        this.matches = matcher.getAllMatches(this.information.getParameterMask(), (ITuple)this.maskedTuple).iterator();
    }

    @Override
    public boolean execute(MatchingFrame frame, ISearchContext context) {
        if (this.matches.hasNext()) {
            Tuple tuple = this.matches.next();
            while (!this.fillInResult(frame, tuple) && this.matches.hasNext()) {
                tuple = this.matches.next();
            }
            return true;
        }
        return false;
    }

    private boolean fillInResult(MatchingFrame frame, Tuple result) {
        int i;
        TupleMask mask = this.information.getFullFrameMask();
        int[] nArray = this.information.getFreeParameterIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            mask.set((IModifiableTuple)frame, i, null);
            ++n2;
        }
        nArray = this.information.getFreeParameterIndices();
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            Object oldValue = mask.getValue((ITuple)frame, i);
            Object valueToFill = result.get(i);
            if (oldValue != null && !oldValue.equals(valueToFill)) {
                return false;
            }
            mask.set((IModifiableTuple)frame, i, valueToFill);
            ++n2;
        }
        return true;
    }

    @Override
    public void onBacktrack(MatchingFrame frame, ISearchContext context) {
        TupleMask mask = this.information.getFullFrameMask();
        int[] nArray = this.information.getFreeParameterIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            mask.set((IModifiableTuple)frame, i, null);
            ++n2;
        }
    }

    @Override
    public List<Integer> getVariablePositions() {
        return this.information.getVariablePositions();
    }

    public String toString() {
        return "extend find " + this.information.toString();
    }
}

