/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;

public class StructuralFeatureCheck
extends CheckOperation {
    int sourcePosition;
    int targetPosition;
    EStructuralFeature feature;

    public StructuralFeatureCheck(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.feature = feature;
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) {
        EObject source;
        block4: {
            Objects.requireNonNull(frame.getValue(this.sourcePosition), () -> String.format("Invalid plan, variable %s unbound", this.sourcePosition));
            Objects.requireNonNull(frame.getValue(this.targetPosition), () -> String.format("Invalid plan, variable %s unbound", this.targetPosition));
            try {
                source = (EObject)frame.getValue(this.sourcePosition);
                if (this.feature.getEContainingClass().isSuperTypeOf(source.eClass())) break block4;
                return false;
            }
            catch (ClassCastException e) {
                throw new LocalSearchException("Invalid type of variable", e);
            }
        }
        Object target = frame.getValue(this.targetPosition);
        if (this.feature.isMany()) {
            return ((Collection)source.eGet(this.feature)).contains(target);
        }
        return target.equals(source.eGet(this.feature));
    }

    public String toString() {
        return "check     " + this.feature.getContainerClass().getSimpleName() + "." + this.feature.getName() + "(+" + this.sourcePosition + ", +" + this.targetPosition + ")";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.sourcePosition, this.targetPosition);
    }
}

