/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableFloatBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableFloatEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableFloatHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableFloatSingletonBag;

public enum ImmutableFloatBagFactoryImpl implements ImmutableFloatBagFactory
{
    INSTANCE;


    @Override
    public ImmutableFloatBag empty() {
        return ImmutableFloatEmptyBag.INSTANCE;
    }

    @Override
    public ImmutableFloatBag of() {
        return this.empty();
    }

    @Override
    public ImmutableFloatBag with() {
        return this.empty();
    }

    @Override
    public ImmutableFloatBag of(float one) {
        return this.with(one);
    }

    @Override
    public ImmutableFloatBag with(float one) {
        return new ImmutableFloatSingletonBag(one);
    }

    @Override
    public ImmutableFloatBag of(float ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableFloatBag with(float ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableFloatHashBag.newBagWith(items);
    }

    @Override
    public ImmutableFloatBag ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableFloatBag withAll(FloatIterable items) {
        if (items instanceof ImmutableFloatBag) {
            return (ImmutableFloatBag)items;
        }
        return this.with(items.toArray());
    }
}

