/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.CoordinateListener;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.layout.LayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.gef4.layout.interfaces.ExpandCollapseManager;
import org.eclipse.gef4.zest.core.widgets.FisheyeListener;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphContainer;
import org.eclipse.gef4.zest.core.widgets.GraphItem;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.core.widgets.IContainer;
import org.eclipse.gef4.zest.core.widgets.InternalLayoutContext;
import org.eclipse.gef4.zest.core.widgets.LayoutFilter;
import org.eclipse.gef4.zest.core.widgets.SubgraphFactory;
import org.eclipse.gef4.zest.core.widgets.decoration.DefaultConnectionDecorator;
import org.eclipse.gef4.zest.core.widgets.decoration.DirectedConnectionDecorator;
import org.eclipse.gef4.zest.core.widgets.decoration.IConnectionDecorator;
import org.eclipse.gef4.zest.core.widgets.gestures.RotateGestureListener;
import org.eclipse.gef4.zest.core.widgets.gestures.ZoomGestureListener;
import org.eclipse.gef4.zest.core.widgets.internal.ContainerFigure;
import org.eclipse.gef4.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.gef4.zest.core.widgets.zooming.ZoomManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphWidget
extends FigureCanvas
implements IContainer {
    public static final int ANIMATION_TIME = 500;
    public static final int FISHEYE_ANIMATION_TIME = 100;
    public Color LIGHT_BLUE = new Color(null, 216, 228, 248);
    public Color LIGHT_BLUE_CYAN = new Color(null, 213, 243, 255);
    public Color GREY_BLUE = new Color(null, 139, 150, 171);
    public Color DARK_BLUE = new Color(null, 1, 70, 122);
    public Color LIGHT_YELLOW = new Color(null, 255, 255, 206);
    public Color HIGHLIGHT_COLOR = ColorConstants.yellow;
    public Color HIGHLIGHT_ADJACENT_COLOR = ColorConstants.orange;
    public Color DEFAULT_NODE_COLOR = this.LIGHT_BLUE;
    private List<GraphNode> nodes;
    protected List<GraphConnection> connections;
    Set<IFigure> subgraphFigures;
    private List<GraphItem> selectedItems = null;
    private List<FisheyeListener> fisheyeListeners = new ArrayList<FisheyeListener>();
    private List<SelectionListener> selectionListeners = null;
    private HashMap<IFigure, GraphItem> figure2ItemMap = null;
    private int connectionStyle;
    private int nodeStyle;
    private ScalableFreeformLayeredPane fishEyeLayer = null;
    private InternalLayoutContext layoutContext = null;
    private volatile boolean shouldSheduleLayout;
    private volatile Runnable scheduledLayoutRunnable = null;
    private volatile boolean scheduledLayoutClean = false;
    private Dimension preferredSize = null;
    int style = 0;
    private ScalableFreeformLayeredPane rootlayer;
    private ZestRootLayer zestRootLayer;
    private ConnectionRouter defaultConnectionRouter;
    private IConnectionDecorator defaultConnectionDecorator = new DefaultConnectionDecorator();
    private IConnectionDecorator defaultDirectedConnectionDecorator = new DirectedConnectionDecorator();
    private ZoomManager zoomManager = null;
    boolean animate = false;
    private Map<Graph.Attr.Value, Integer> map = new HashMap<Graph.Attr.Value, Integer>(){
        {
            this.put(Graph.Attr.Value.GRAPH_DIRECTED, 2);
            this.put(Graph.Attr.Value.GRAPH_UNDIRECTED, 4);
            this.put(Graph.Attr.Value.LINE_DASH, 2);
            this.put(Graph.Attr.Value.LINE_DASHDOT, 4);
            this.put(Graph.Attr.Value.LINE_DASHDOTDOT, 5);
            this.put(Graph.Attr.Value.LINE_DOT, 3);
            this.put(Graph.Attr.Value.LINE_SOLID, 1);
            this.put(Graph.Attr.Value.NONE, 0);
        }
    };
    private Graph dotGraph;

    public GraphWidget(Composite parent, int style) {
        super(parent, (style | 0x20000000) & 0xFFFFFFBF);
        this.style = style;
        this.setBackground(ColorConstants.white);
        this.setViewport((Viewport)new FreeformViewport());
        this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphWidget.this.redraw();
            }
        });
        this.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphWidget.this.redraw();
            }
        });
        this.getLightweightSystem().setEventDispatcher((EventDispatcher)new SWTEventDispatcher(){

            public void dispatchMouseMoved(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMouseMoved(me);
                if (this.getCurrentEvent() == null) {
                    return;
                }
                if (this.getMouseTarget() == null) {
                    this.setMouseTarget(this.getRoot());
                }
                if ((me.stateMask & SWT.BUTTON_MASK) != 0) {
                    this.getMouseTarget().handleMouseDragged(this.getCurrentEvent());
                } else {
                    this.getMouseTarget().handleMouseMoved(this.getCurrentEvent());
                }
            }
        });
        this.setContents((IFigure)this.createLayers());
        DragSupport dragSupport = new DragSupport();
        this.getLightweightSystem().getRootFigure().addMouseListener((MouseListener)dragSupport);
        this.getLightweightSystem().getRootFigure().addMouseMotionListener((MouseMotionListener)dragSupport);
        this.nodes = new ArrayList<GraphNode>();
        this.preferredSize = new Dimension(-1, -1);
        this.connectionStyle = 0;
        this.nodeStyle = 0;
        this.connections = new ArrayList<GraphConnection>();
        this.subgraphFigures = new HashSet<IFigure>();
        this.selectedItems = new ArrayList<GraphItem>();
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.figure2ItemMap = new HashMap();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (GraphWidget.this.shouldSheduleLayout) {
                    GraphWidget.this.applyLayoutInternal(true);
                    GraphWidget.this.shouldSheduleLayout = false;
                }
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (((GraphWidget)GraphWidget.this).preferredSize.width == -1 || ((GraphWidget)GraphWidget.this).preferredSize.height == -1) {
                    GraphWidget.this.getLayoutContext().fireBoundsChangedEvent();
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        if ((style & 0x40) == 0) {
            this.addGestureListener(new ZoomGestureListener());
            this.addGestureListener(new RotateGestureListener());
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GraphWidget.this.release();
            }
        });
    }

    public GraphWidget(Graph graph, Composite parent, int style) {
        this(parent, style);
        this.dotGraph = graph;
        HashMap<Node, GraphNode> nodes = new HashMap<Node, GraphNode>();
        for (Node node : this.dotGraph.getNodes()) {
            GraphNode graphNode = this.dotNodeToZestNode(node);
            nodes.put(node, graphNode);
        }
        for (Edge edge : this.dotGraph.getEdges()) {
            GraphNode sourceZestNode = (GraphNode)((Object)nodes.get(edge.getSource()));
            GraphNode targetZestNode = (GraphNode)((Object)nodes.get(edge.getTarget()));
            this.dotEdgeToZestEdge(edge, sourceZestNode, targetZestNode);
        }
        this.setLayout(this.dotGraph);
        this.setGraphData(this.dotGraph);
        this.setGraphType(this.dotGraph);
    }

    private void setLayout(Graph dotGraph) {
        TreeLayoutAlgorithm algorithm = new TreeLayoutAlgorithm();
        Object layout = dotGraph.getAttrs().get(Graph.Attr.Key.LAYOUT.toString());
        if (layout != null) {
            algorithm = (LayoutAlgorithm)layout;
        }
        this.setLayoutAlgorithm((LayoutAlgorithm)algorithm, true);
    }

    private void setGraphData(Graph dotGraph) {
        for (Map.Entry entry : dotGraph.getAttrs().entrySet()) {
            this.setData((String)entry.getKey(), entry.getValue());
        }
    }

    private void setGraphType(Graph dotGraph) {
        Object type = dotGraph.getAttrs().get(Graph.Attr.Key.GRAPH_TYPE.toString());
        if (type != null) {
            this.setConnectionStyle(this.map.get(Graph.Attr.Value.valueOf((String)type.toString())));
        }
    }

    private GraphConnection dotEdgeToZestEdge(Edge edge, GraphNode sourceZestNode, GraphNode targetZestNode) {
        Object data;
        Object label;
        int graphType = 0;
        Graph.Attr.Value type = (Graph.Attr.Value)this.dotGraph.getAttrs().get(Graph.Attr.Key.GRAPH_TYPE.toString());
        if (type != null) {
            graphType = this.map.get(type);
        }
        GraphConnection connection = new GraphConnection(this, graphType, sourceZestNode, targetZestNode);
        Object edgeStyle = edge.getAttrs().get(Graph.Attr.Key.EDGE_STYLE.toString());
        if (edgeStyle != null) {
            Integer style = this.map.get(Graph.Attr.Value.valueOf((String)edgeStyle.toString()));
            connection.setLineStyle(style);
        }
        if ((label = edge.getAttrs().get(Graph.Attr.Key.LABEL.toString())) != null) {
            connection.setText(label.toString());
        }
        if ((data = edge.getAttrs().get(Graph.Attr.Key.ID.toString())) != null) {
            connection.setData(data);
        }
        return connection;
    }

    private GraphNode dotNodeToZestNode(Node node) {
        Object data;
        GraphNode graphNode = new GraphNode(this, 0);
        Object label = node.getAttrs().get(Graph.Attr.Key.LABEL.toString());
        if (label != null) {
            graphNode.setText(label.toString());
        }
        if ((data = node.getAttrs().get(Graph.Attr.Key.ID.toString())) != null) {
            graphNode.setData(data);
        }
        return graphNode;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (!this.selectionListeners.contains(selectionListener)) {
            this.selectionListeners.add(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this.selectionListeners.contains(selectionListener)) {
            this.selectionListeners.remove(selectionListener);
        }
    }

    @Override
    public List<GraphNode> getNodes() {
        return this.nodes;
    }

    public ScalableFigure getRootLayer() {
        return this.rootlayer;
    }

    public void setConnectionStyle(int connectionStyle) {
        this.connectionStyle = connectionStyle;
    }

    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    public void setNodeStyle(int nodeStyle) {
        this.nodeStyle = nodeStyle;
    }

    public int getNodeStyle() {
        return this.nodeStyle;
    }

    @Override
    public List<GraphConnection> getConnections() {
        return this.connections;
    }

    public void setSelection(GraphItem[] items) {
        this.clearSelection();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                if (items[i] != null) {
                    this.select(items[i]);
                }
                ++i;
            }
        }
    }

    public void selectAll() {
        this.setSelection(this.nodes.toArray(new GraphItem[0]));
    }

    public List<GraphItem> getSelection() {
        return this.selectedItems;
    }

    public String toString() {
        return "GraphModel {" + this.nodes.size() + " nodes, " + this.connections.size() + " connections}";
    }

    public void dispose() {
        this.release();
        super.dispose();
    }

    @Override
    public void applyLayout() {
        this.scheduleLayoutOnReveal(true);
    }

    public void applyLayoutNow() {
        this.getLayoutContext().applyStaticLayout(true);
        this.layoutContext.flushChanges(false);
    }

    public void setDynamicLayout(boolean enabled) {
        if (this.getLayoutContext().isDynamicLayoutEnabled() != enabled) {
            this.layoutContext.setDynamicLayoutEnabled(enabled);
            if (enabled) {
                this.scheduleLayoutOnReveal(false);
            }
        }
    }

    public boolean isDynamicLayoutEnabled() {
        return this.getLayoutContext().isDynamicLayoutEnabled();
    }

    private void release() {
        while (this.nodes.size() > 0) {
            GraphNode node = this.nodes.get(0);
            if (node == null) continue;
            node.dispose();
        }
        while (this.connections.size() > 0) {
            GraphConnection connection = this.connections.get(0);
            if (connection == null) continue;
            connection.dispose();
        }
        this.LIGHT_BLUE.dispose();
        this.LIGHT_BLUE_CYAN.dispose();
        this.GREY_BLUE.dispose();
        this.DARK_BLUE.dispose();
        this.LIGHT_YELLOW.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLayoutInternal(boolean clean) {
        if (this.getLayoutContext().getLayoutAlgorithm() == null) {
            return;
        }
        this.scheduledLayoutClean = this.scheduledLayoutClean || clean;
        GraphWidget graphWidget = this;
        synchronized (graphWidget) {
            if (this.scheduledLayoutRunnable == null) {
                this.scheduledLayoutRunnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (GraphWidget.this.animate) {
                            Animation.markBegin();
                        }
                        GraphWidget.this.getLayoutContext().applyStaticLayout(GraphWidget.this.scheduledLayoutClean);
                        GraphWidget.this.layoutContext.flushChanges(false);
                        if (GraphWidget.this.animate) {
                            Animation.run((int)500);
                        }
                        GraphWidget.this.getLightweightSystem().getUpdateManager().performUpdate();
                        GraphWidget graphWidget = GraphWidget.this;
                        synchronized (graphWidget) {
                            GraphWidget.this.scheduledLayoutRunnable = null;
                            GraphWidget.this.scheduledLayoutClean = false;
                        }
                    }
                };
                Display.getDefault().asyncExec(this.scheduledLayoutRunnable);
            }
        }
    }

    public void setPreferredSize(int width, int height) {
        this.preferredSize = new Dimension(width, height);
        this.getLayoutContext().fireBoundsChangedEvent();
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize.width < 0 || this.preferredSize.height < 0) {
            org.eclipse.swt.graphics.Point size = this.getSize();
            double scale = this.getZoomManager().getZoom();
            return new Dimension((int)((double)size.x / scale + 0.5), (int)((double)size.y / scale + 0.5));
        }
        return this.preferredSize;
    }

    @Override
    public InternalLayoutContext getLayoutContext() {
        if (this.layoutContext == null) {
            this.layoutContext = new InternalLayoutContext(this);
        }
        return this.layoutContext;
    }

    @Override
    public void setLayoutAlgorithm(LayoutAlgorithm algorithm, boolean applyLayout) {
        this.getLayoutContext().setLayoutAlgorithm(algorithm);
        if (applyLayout) {
            this.applyLayout();
        }
    }

    public LayoutAlgorithm getLayoutAlgorithm() {
        return this.getLayoutContext().getLayoutAlgorithm();
    }

    public void setSubgraphFactory(SubgraphFactory factory) {
        this.getLayoutContext().setSubgraphFactory(factory);
    }

    public SubgraphFactory getSubgraphFactory() {
        return this.getLayoutContext().getSubgraphFactory();
    }

    public void setExpandCollapseManager(ExpandCollapseManager expandCollapseManager) {
        this.getLayoutContext().setExpandCollapseManager(expandCollapseManager);
        this.setDynamicLayout(true);
    }

    public ExpandCollapseManager getExpandCollapseManager() {
        return this.getLayoutContext().getExpandCollapseManager();
    }

    public void addLayoutFilter(LayoutFilter filter) {
        this.getLayoutContext().addFilter(filter);
    }

    public void removeLayoutFilter(LayoutFilter filter) {
        this.getLayoutContext().removeFilter(filter);
    }

    public IFigure getFigureAt(int x, int y) {
        IFigure figureUnderMouse = this.getContents().findFigureAt(x, y, new TreeSearch(){

            public boolean accept(IFigure figure) {
                return true;
            }

            public boolean prune(IFigure figure) {
                IFigure parent = figure.getParent();
                if (parent == GraphWidget.this.fishEyeLayer) {
                    return true;
                }
                if (parent instanceof ContainerFigure && figure instanceof PolylineConnection) {
                    return false;
                }
                if (parent == GraphWidget.this.zestRootLayer || parent == GraphWidget.this.zestRootLayer.getParent() || parent == GraphWidget.this.zestRootLayer.getParent().getParent()) {
                    return false;
                }
                GraphItem item = (GraphItem)((Object)GraphWidget.this.figure2ItemMap.get(figure));
                if (item != null && item.getItemType() == 3) {
                    return false;
                }
                return !(figure instanceof FreeformLayer) && !(parent instanceof FreeformLayer) && !(figure instanceof ScrollPane) && !(parent instanceof ScrollPane) && !(parent instanceof ScalableFreeformLayeredPane) && !(figure instanceof ScalableFreeformLayeredPane) && !(figure instanceof FreeformViewport) && !(parent instanceof FreeformViewport);
            }
        });
        return figureUnderMouse;
    }

    public void notifyListeners(int eventType, Event event) {
        super.notifyListeners(eventType, event);
        if (eventType == 13 && event != null) {
            this.notifySelectionListeners(new SelectionEvent(event));
        }
    }

    private void clearSelection() {
        Iterator<GraphItem> iterator = new ArrayList<GraphItem>(this.selectedItems).iterator();
        while (iterator.hasNext()) {
            this.deselect(iterator.next());
        }
    }

    private void fireWidgetSelectedEvent(Item item) {
        Event swtEvent = new Event();
        swtEvent.item = item;
        swtEvent.widget = this;
        this.notifySelectionListeners(new SelectionEvent(swtEvent));
    }

    private void notifySelectionListeners(SelectionEvent event) {
        Iterator<SelectionListener> iterator = this.selectionListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().widgetSelected(event);
        }
    }

    private void deselect(GraphItem item) {
        this.selectedItems.remove((Object)item);
        item.unhighlight();
        this.setNodeSelected(item, false);
    }

    private void select(GraphItem item) {
        this.selectedItems.add(item);
        item.highlight();
        this.setNodeSelected(item, true);
    }

    private void setNodeSelected(GraphItem item, boolean selected) {
        if (item instanceof GraphNode) {
            ((GraphNode)item).setSelected(selected);
        }
    }

    GraphConnection[] getConnectionsArray() {
        GraphConnection[] connsArray = new GraphConnection[this.connections.size()];
        connsArray = this.connections.toArray(connsArray);
        return connsArray;
    }

    public void clear() {
        Iterator<GraphItem> i = new ArrayList<GraphConnection>(this.connections).iterator();
        while (i.hasNext()) {
            this.removeConnection(i.next());
        }
        i = new HashSet<IFigure>(this.subgraphFigures).iterator();
        while (i.hasNext()) {
            this.removeSubgraphFigure((IFigure)i.next());
        }
        i = new ArrayList<GraphNode>(this.nodes).iterator();
        while (i.hasNext()) {
            this.removeNode((GraphNode)i.next());
        }
    }

    void removeConnection(GraphConnection connection) {
        Connection figure = connection.getConnectionFigure();
        PolylineConnection sourceContainerConnectionFigure = connection.getSourceContainerConnectionFigure();
        PolylineConnection targetContainerConnectionFigure = connection.getTargetContainerConnectionFigure();
        connection.removeFigure();
        this.getConnections().remove((Object)connection);
        this.selectedItems.remove((Object)connection);
        this.figure2ItemMap.remove(figure);
        if (sourceContainerConnectionFigure != null) {
            this.figure2ItemMap.remove(sourceContainerConnectionFigure);
        }
        if (targetContainerConnectionFigure != null) {
            this.figure2ItemMap.remove(targetContainerConnectionFigure);
        }
        this.getLayoutContext().fireConnectionRemovedEvent(connection.getLayout());
    }

    void removeNode(GraphNode node) {
        IFigure figure = node.getNodeFigure();
        if (figure.getParent() != null) {
            figure.getParent().remove(figure);
        }
        this.getNodes().remove((Object)node);
        this.selectedItems.remove((Object)node);
        this.figure2ItemMap.remove(figure);
        node.getLayout().dispose();
    }

    void addConnection(GraphConnection connection, boolean addToEdgeLayer) {
        this.getConnections().add(connection);
        if (addToEdgeLayer) {
            this.zestRootLayer.addConnection(connection.getFigure());
        }
        this.getLayoutContext().fireConnectionAddedEvent(connection.getLayout());
    }

    @Override
    public void addNode(GraphNode node) {
        this.getNodes().add(node);
        this.zestRootLayer.addNode(node.getFigure());
        this.getLayoutContext().fireNodeAddedEvent(node.getLayout());
    }

    @Override
    public void addSubgraphFigure(IFigure figure) {
        this.zestRootLayer.addSubgraph(figure);
        this.subgraphFigures.add(figure);
    }

    void removeSubgraphFigure(IFigure figure) {
        this.subgraphFigures.remove(figure);
        figure.getParent().remove(figure);
    }

    void registerItem(GraphItem item) {
        if (item.getItemType() == 1) {
            IFigure figure = item.getFigure();
            this.figure2ItemMap.put(figure, item);
        } else if (item.getItemType() == 2) {
            IFigure figure = item.getFigure();
            this.figure2ItemMap.put(figure, item);
            if (((GraphConnection)item).getSourceContainerConnectionFigure() != null) {
                this.figure2ItemMap.put((IFigure)((GraphConnection)item).getSourceContainerConnectionFigure(), item);
            }
            if (((GraphConnection)item).getTargetContainerConnectionFigure() != null) {
                this.figure2ItemMap.put((IFigure)((GraphConnection)item).getTargetContainerConnectionFigure(), item);
            }
        } else if (item.getItemType() == 3) {
            IFigure figure = item.getFigure();
            this.figure2ItemMap.put(figure, item);
        } else {
            throw new RuntimeException("Unknown item type: " + item.getItemType());
        }
    }

    private void scheduleLayoutOnReveal(boolean clean) {
        final boolean[] isVisibleSync = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                isVisibleSync[0] = GraphWidget.this.isVisible();
            }
        });
        if (isVisibleSync[0]) {
            this.applyLayoutInternal(clean);
        } else {
            this.shouldSheduleLayout = true;
        }
    }

    private ScalableFigure createLayers() {
        this.rootlayer = new ScalableFreeformLayeredPane();
        this.rootlayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.zestRootLayer = new ZestRootLayer();
        this.zestRootLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.fishEyeLayer = new ScalableFreeformLayeredPane();
        this.fishEyeLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.rootlayer.add((IFigure)this.zestRootLayer);
        this.rootlayer.add((IFigure)this.fishEyeLayer);
        this.zestRootLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.fishEyeLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.rootlayer.addCoordinateListener(new CoordinateListener(){

            public void coordinateSystemChanged(IFigure source) {
                if (((GraphWidget)GraphWidget.this).preferredSize.width == -1 && ((GraphWidget)GraphWidget.this).preferredSize.height == -1) {
                    GraphWidget.this.getLayoutContext().fireBoundsChangedEvent();
                }
            }
        });
        return this.rootlayer;
    }

    void removeFishEye(IFigure fishEyeFigure, IFigure regularFigure, boolean animate) {
        if (!this.fishEyeLayer.getChildren().contains(fishEyeFigure)) {
            return;
        }
        if (animate) {
            Animation.markBegin();
        }
        Rectangle bounds = regularFigure.getBounds().getCopy();
        regularFigure.translateToAbsolute((Translatable)bounds);
        double scale = this.rootlayer.getScale();
        this.fishEyeLayer.setScale(1.0 / scale);
        this.fishEyeLayer.translateToRelative((Translatable)bounds);
        this.fishEyeLayer.translateFromParent((Translatable)bounds);
        this.fishEyeLayer.setConstraint(fishEyeFigure, (Object)bounds);
        for (FisheyeListener listener : this.fisheyeListeners) {
            listener.fisheyeRemoved(this, regularFigure, fishEyeFigure);
        }
        if (animate) {
            Animation.run((int)200);
        }
        this.getRootLayer().getUpdateManager().performUpdate();
        this.fishEyeLayer.removeAll();
    }

    boolean replaceFishFigure(IFigure oldFigure, IFigure newFigure) {
        if (this.fishEyeLayer.getChildren().contains(oldFigure)) {
            Rectangle bounds = oldFigure.getBounds();
            newFigure.setBounds(bounds);
            this.fishEyeLayer.remove(oldFigure);
            this.fishEyeLayer.add(newFigure);
            for (FisheyeListener listener : this.fisheyeListeners) {
                listener.fisheyeReplaced(this, oldFigure, newFigure);
            }
            return true;
        }
        return false;
    }

    void fishEye(IFigure startFigure, IFigure endFigure, Rectangle newBounds, boolean animate) {
        this.fishEyeLayer.removeAll();
        if (animate) {
            Animation.markBegin();
        }
        double scale = this.rootlayer.getScale();
        this.fishEyeLayer.setScale(1.0 / scale);
        this.fishEyeLayer.translateToRelative((Translatable)newBounds);
        this.fishEyeLayer.translateFromParent((Translatable)newBounds);
        Rectangle bounds = startFigure.getBounds().getCopy();
        startFigure.translateToAbsolute((Translatable)bounds);
        this.fishEyeLayer.translateToRelative((Translatable)bounds);
        this.fishEyeLayer.translateFromParent((Translatable)bounds);
        endFigure.setLocation(bounds.getLocation());
        endFigure.setSize(bounds.getSize());
        this.fishEyeLayer.add(endFigure);
        this.fishEyeLayer.setConstraint(endFigure, (Object)newBounds);
        for (FisheyeListener listener : this.fisheyeListeners) {
            listener.fisheyeAdded(this, startFigure, endFigure);
        }
        if (animate) {
            Animation.run((int)100);
        }
        this.getRootLayer().getUpdateManager().performUpdate();
    }

    public void addFisheyeListener(FisheyeListener listener) {
        this.fisheyeListeners.add(listener);
    }

    public void removeFisheyeListener(FisheyeListener listener) {
        this.fisheyeListeners.remove(listener);
    }

    @Override
    public int getItemType() {
        return 0;
    }

    GraphItem getGraphItem(IFigure figure) {
        return this.figure2ItemMap.get(figure);
    }

    public void setExpanded(GraphNode node, boolean expanded) {
        this.layoutContext.setExpanded(node.getLayout(), expanded);
        this.rootlayer.invalidate();
    }

    public boolean canExpand(GraphNode node) {
        return this.layoutContext.canExpand(node.getLayout());
    }

    public boolean canCollapse(GraphNode node) {
        return this.layoutContext.canCollapse(node.getLayout());
    }

    @Override
    public GraphWidget getGraph() {
        return this;
    }

    @Override
    public Widget getItem() {
        return this;
    }

    @Override
    public org.eclipse.gef4.geometry.planar.Rectangle getLayoutBounds() {
        Dimension preferredSize = this.getPreferredSize();
        return new org.eclipse.gef4.geometry.planar.Rectangle(0.0, 0.0, (double)preferredSize.width, (double)preferredSize.height);
    }

    void setDefaultConnectionRouter(ConnectionRouter defaultConnectionRouter) {
        this.defaultConnectionRouter = defaultConnectionRouter;
    }

    ConnectionRouter getDefaultConnectionRouter() {
        return this.defaultConnectionRouter;
    }

    public IConnectionDecorator getDefaultConnectionDecorator() {
        return this.defaultConnectionDecorator;
    }

    public void setDefaultConnectionDecorator(IConnectionDecorator connectionDecorator) {
        this.defaultConnectionDecorator = connectionDecorator == null ? new DefaultConnectionDecorator() : connectionDecorator;
    }

    public IConnectionDecorator getDefaultDirectedConnectionDecorator() {
        return this.defaultDirectedConnectionDecorator;
    }

    public void setDefaultDirectedConnectionDecorator(IConnectionDecorator connectionDecorator) {
        this.defaultDirectedConnectionDecorator = connectionDecorator;
    }

    void applyConnectionRouter() {
        for (GraphConnection conn : this.getConnections()) {
            conn.getConnectionFigure().setConnectionRouter(this.defaultConnectionRouter);
        }
        this.getRootLayer().getUpdateManager().performUpdate();
    }

    public void setRouter(ConnectionRouter connectionRouter) {
        this.setDefaultConnectionRouter(connectionRouter);
        this.applyConnectionRouter();
    }

    public ZoomManager getZoomManager() {
        if (this.zoomManager == null) {
            this.zoomManager = new ZoomManager(this.getRootLayer(), this.getViewport());
        }
        return this.zoomManager;
    }

    public boolean isAnimationEnabled() {
        return this.animate;
    }

    public void setAnimationEnabled(boolean animate) {
        this.animate = animate;
    }

    private class DragSupport
    implements MouseMotionListener,
    MouseListener {
        Point dragStartLocation = null;
        IFigure draggedSubgraphFigure = null;
        ArrayList<Point> relativeLocations = new ArrayList();
        GraphItem fisheyedItem = null;
        boolean isDragging = false;

        private DragSupport() {
        }

        public void mouseDragged(MouseEvent me) {
            IFigure figureUnderMouse;
            if (!this.isDragging) {
                return;
            }
            if (GraphWidget.this.selectedItems.isEmpty() && GraphWidget.this.subgraphFigures.contains(figureUnderMouse = GraphWidget.this.getFigureAt(this.dragStartLocation.x, this.dragStartLocation.y))) {
                this.draggedSubgraphFigure = figureUnderMouse;
            }
            Point mousePoint = new Point(me.x, me.y);
            if (!GraphWidget.this.selectedItems.isEmpty() || this.draggedSubgraphFigure != null) {
                if (this.relativeLocations.isEmpty()) {
                    for (GraphItem item : GraphWidget.this.selectedItems) {
                        if (item.getItemType() != 1 && item.getItemType() != 3) continue;
                        this.relativeLocations.add(this.getRelativeLocation(item.getFigure()));
                    }
                    if (this.draggedSubgraphFigure != null) {
                        this.relativeLocations.add(this.getRelativeLocation(this.draggedSubgraphFigure));
                    }
                }
                Iterator<Point> locationsIterator = this.relativeLocations.iterator();
                for (GraphItem item : GraphWidget.this.selectedItems) {
                    if (item.getItemType() != 1 && item.getItemType() != 3) continue;
                    Point pointCopy = mousePoint.getCopy();
                    Point relativeLocation = locationsIterator.next();
                    item.getFigure().getParent().translateToRelative((Translatable)pointCopy);
                    item.getFigure().getParent().translateFromParent((Translatable)pointCopy);
                    ((GraphNode)item).setLocation(relativeLocation.x + pointCopy.x, relativeLocation.y + pointCopy.y);
                }
                if (this.draggedSubgraphFigure != null) {
                    Point pointCopy = mousePoint.getCopy();
                    this.draggedSubgraphFigure.getParent().translateToRelative((Translatable)pointCopy);
                    this.draggedSubgraphFigure.getParent().translateFromParent((Translatable)pointCopy);
                    Point relativeLocation = locationsIterator.next();
                    pointCopy.x += relativeLocation.x;
                    pointCopy.y += relativeLocation.y;
                    this.draggedSubgraphFigure.setLocation(pointCopy);
                }
            }
        }

        private Point getRelativeLocation(IFigure figure) {
            Point location = figure.getBounds().getTopLeft();
            Point mousePointCopy = this.dragStartLocation.getCopy();
            figure.getParent().translateToRelative((Translatable)mousePointCopy);
            figure.getParent().translateFromParent((Translatable)mousePointCopy);
            location.x -= mousePointCopy.x;
            location.y -= mousePointCopy.y;
            return location;
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
            Point mousePoint = new Point(me.x, me.y);
            GraphWidget.this.getRootLayer().translateToRelative((Translatable)mousePoint);
            IFigure figureUnderMouse = GraphWidget.this.getFigureAt(mousePoint.x, mousePoint.y);
            if (figureUnderMouse != null) {
                GraphItem itemUnderMouse = (GraphItem)((Object)GraphWidget.this.figure2ItemMap.get(figureUnderMouse));
                if (itemUnderMouse == this.fisheyedItem) {
                    return;
                }
                if (this.fisheyedItem != null) {
                    ((GraphNode)this.fisheyedItem).fishEye(false, GraphWidget.this.animate);
                    this.fisheyedItem = null;
                }
                if (itemUnderMouse != null && itemUnderMouse.getItemType() == 1) {
                    this.fisheyedItem = itemUnderMouse;
                    IFigure fisheyedFigure = ((GraphNode)itemUnderMouse).fishEye(true, GraphWidget.this.animate);
                    if (fisheyedFigure == null) {
                        this.fisheyedItem = null;
                    }
                }
            } else if (this.fisheyedItem != null) {
                ((GraphNode)this.fisheyedItem).fishEye(false, GraphWidget.this.animate);
                this.fisheyedItem = null;
            }
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            this.isDragging = true;
            Point mousePoint = new Point(me.x, me.y);
            this.dragStartLocation = mousePoint.getCopy();
            GraphWidget.this.getRootLayer().translateToRelative((Translatable)mousePoint);
            if ((me.getState() & SWT.MOD3) != 0) {
                if ((me.getState() & SWT.MOD2) == 0) {
                    double scale = GraphWidget.this.getRootLayer().getScale();
                    GraphWidget.this.getRootLayer().setScale(scale *= 1.05);
                    Point newMousePoint = mousePoint.getCopy().scale(1.05);
                    Point delta = new Point(newMousePoint.x - mousePoint.x, newMousePoint.y - mousePoint.y);
                    Point newViewLocation = GraphWidget.this.getViewport().getViewLocation().getCopy().translate(delta);
                    GraphWidget.this.getViewport().setViewLocation(newViewLocation);
                    GraphWidget.this.clearSelection();
                    return;
                }
                double scale = GraphWidget.this.getRootLayer().getScale();
                GraphWidget.this.getRootLayer().setScale(scale /= 1.05);
                Point newMousePoint = mousePoint.getCopy().scale(0.9523809523809523);
                Point delta = new Point(newMousePoint.x - mousePoint.x, newMousePoint.y - mousePoint.y);
                Point newViewLocation = GraphWidget.this.getViewport().getViewLocation().getCopy().translate(delta);
                GraphWidget.this.getViewport().setViewLocation(newViewLocation);
                GraphWidget.this.clearSelection();
                return;
            }
            boolean hasSelection = GraphWidget.this.selectedItems.size() > 0;
            IFigure figureUnderMouse = GraphWidget.this.getFigureAt(mousePoint.x, mousePoint.y);
            GraphWidget.this.getRootLayer().translateFromParent((Translatable)mousePoint);
            if (figureUnderMouse != null) {
                figureUnderMouse.getParent().translateFromParent((Translatable)mousePoint);
            }
            if (figureUnderMouse == null || figureUnderMouse == GraphWidget.this) {
                if ((me.getState() & SWT.MOD1) == 0) {
                    GraphWidget.this.clearSelection();
                    if (hasSelection) {
                        GraphWidget.this.fireWidgetSelectedEvent(null);
                        hasSelection = false;
                    }
                }
                return;
            }
            GraphItem itemUnderMouse = (GraphItem)((Object)GraphWidget.this.figure2ItemMap.get(figureUnderMouse));
            if (itemUnderMouse == null) {
                if ((me.getState() & SWT.MOD1) != 0) {
                    GraphWidget.this.clearSelection();
                    if (hasSelection) {
                        GraphWidget.this.fireWidgetSelectedEvent(null);
                        hasSelection = false;
                    }
                }
                return;
            }
            if (GraphWidget.this.selectedItems.contains((Object)itemUnderMouse)) {
                if ((me.getState() & SWT.MOD1) != 0) {
                    GraphWidget.this.selectedItems.remove((Object)itemUnderMouse);
                    itemUnderMouse.unhighlight();
                    GraphWidget.this.fireWidgetSelectedEvent(itemUnderMouse);
                }
                return;
            }
            if ((me.getState() & SWT.MOD1) == 0) {
                GraphWidget.this.clearSelection();
            }
            if (itemUnderMouse.getItemType() == 1) {
                GraphWidget.this.selectedItems.add(itemUnderMouse);
                ((GraphNode)itemUnderMouse).highlight();
                GraphWidget.this.fireWidgetSelectedEvent(itemUnderMouse);
            } else if (itemUnderMouse.getItemType() == 2) {
                GraphWidget.this.selectedItems.add(itemUnderMouse);
                ((GraphConnection)itemUnderMouse).highlight();
                GraphWidget.this.fireWidgetSelectedEvent(itemUnderMouse);
            } else if (itemUnderMouse.getItemType() == 3) {
                GraphWidget.this.selectedItems.add(itemUnderMouse);
                ((GraphContainer)itemUnderMouse).highlight();
                GraphWidget.this.fireWidgetSelectedEvent(itemUnderMouse);
            }
        }

        public void mouseReleased(MouseEvent me) {
            this.isDragging = false;
            this.relativeLocations.clear();
            this.draggedSubgraphFigure = null;
        }
    }
}

