/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.LayoutAlgorithm;
import org.eclipse.gef4.layout.interfaces.EntityLayout;
import org.eclipse.gef4.layout.interfaces.LayoutContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalShiftAlgorithm
implements LayoutAlgorithm {
    private static final double DELTA = 10.0;
    private static final double VSPACING = 16.0;
    private LayoutContext context;

    @Override
    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        ArrayList<List<EntityLayout>> rowsList = new ArrayList<List<EntityLayout>>();
        EntityLayout[] entities = this.context.getEntities();
        int i = 0;
        while (i < entities.length) {
            this.addToRowList(entities[i], rowsList);
            ++i;
        }
        Collections.sort(rowsList, new Comparator<List<EntityLayout>>(){

            @Override
            public int compare(List<EntityLayout> o1, List<EntityLayout> o2) {
                EntityLayout entity0 = o1.get(0);
                EntityLayout entity1 = o2.get(0);
                return (int)(entity0.getLocation().y - entity1.getLocation().y);
            }
        });
        Comparator<EntityLayout> entityComparator = new Comparator<EntityLayout>(){

            @Override
            public int compare(EntityLayout o1, EntityLayout o2) {
                return (int)(o1.getLocation().y - o2.getLocation().y);
            }
        };
        Rectangle bounds = this.context.getBounds();
        int heightSoFar = 0;
        for (List<EntityLayout> currentRow : rowsList) {
            Collections.sort(currentRow, entityComparator);
            int i2 = 0;
            int width = (int)(bounds.getWidth() / 2.0 - (double)(currentRow.size() * 75));
            heightSoFar = (int)((double)heightSoFar + (currentRow.get((int)0).getSize().height + 16.0));
            for (EntityLayout entity : currentRow) {
                Dimension size = entity.getSize();
                entity.setLocation((double)(width + 10 * ++i2) + size.width / 2.0, (double)heightSoFar + size.height / 2.0);
                width = (int)((double)width + size.width);
            }
        }
    }

    @Override
    public void setLayoutContext(LayoutContext context) {
        this.context = context;
    }

    @Override
    public LayoutContext getLayoutContext() {
        return this.context;
    }

    private void addToRowList(EntityLayout entity, ArrayList<List<EntityLayout>> rowsList) {
        double layoutY = entity.getLocation().y;
        for (List<EntityLayout> currentRow : rowsList) {
            EntityLayout currentRowEntity = currentRow.get(0);
            double currentRowY = currentRowEntity.getLocation().y;
            if (!(layoutY >= currentRowY - 10.0) || !(layoutY <= currentRowY + 10.0)) continue;
            currentRow.add(entity);
            return;
        }
        ArrayList<EntityLayout> newRow = new ArrayList<EntityLayout>();
        newRow.add(entity);
        rowsList.add(newRow);
    }
}

