/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.tests.io.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BitBufferTest {
    private BitBuffer fixture;

    @Before
    public void setUp() throws CTFException {
        this.fixture = new BitBuffer(Util.testMemory(ByteBuffer.allocateDirect(1)));
        this.fixture.setByteOrder(ByteOrder.BIG_ENDIAN);
        this.fixture.position(1L);
    }

    @Test
    public void testBitBuffer() {
        BitBuffer result = new BitBuffer();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.position());
        Assert.assertNotNull((Object)result.getByteBuffer());
    }

    @Test
    public void testBitBuffer_fromByteBuffer() {
        BitBuffer result = new BitBuffer(Util.testMemory(ByteBuffer.allocate(0)));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.position());
    }

    @Test
    public void testCanRead_1param() {
        int length = 1;
        boolean result = this.fixture.canRead(length);
        Assert.assertEquals((Object)true, (Object)result);
    }

    @Test
    public void testClear() {
        this.fixture.clear();
    }

    @Test
    public void testGetByteBuffer() {
        ByteBuffer result = this.fixture.getByteBuffer();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"java.nio.DirectByteBuffer[pos=0 lim=1 cap=1]", (Object)result.toString());
        Assert.assertEquals((Object)true, (Object)result.isDirect());
        Assert.assertEquals((Object)false, (Object)result.hasArray());
        Assert.assertEquals((long)1L, (long)result.limit());
        Assert.assertEquals((long)1L, (long)result.remaining());
        Assert.assertEquals((long)0L, (long)result.position());
        Assert.assertEquals((long)1L, (long)result.capacity());
        Assert.assertEquals((Object)true, (Object)result.hasRemaining());
        Assert.assertEquals((Object)false, (Object)result.isReadOnly());
    }

    @Test
    public void testGetByteOrder() {
        ByteOrder result = this.fixture.getByteOrder();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"BIG_ENDIAN", (Object)result.toString());
    }

    @Test
    public void testGetOrder() {
        ByteOrder result = this.fixture.getByteOrder();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"BIG_ENDIAN", (Object)result.toString());
    }

    @Test
    public void testSetOrder() {
        ByteOrder order = ByteOrder.BIG_ENDIAN;
        this.fixture.setByteOrder(order);
    }

    @Test
    public void testGetPosition() {
        long result = this.fixture.position();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testSetPosition() throws CTFException {
        int newPosition = 1;
        this.fixture.position((long)newPosition);
    }

    @Test
    public void testSetByteOrder() {
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        this.fixture.setByteOrder(byteOrder);
    }

    @Test
    public void testGetBytes() {
        byte @NonNull [] data = new byte[2];
        ByteBuffer bb = ByteBuffer.allocate(10);
        bb.put((byte)0);
        bb.put((byte)1);
        bb.put((byte)1);
        bb.put((byte)0);
        this.fixture = new BitBuffer(bb);
        this.fixture.get(data);
        Assert.assertEquals((long)0L, (long)data[0]);
        Assert.assertEquals((long)1L, (long)data[1]);
        this.fixture.get(data);
        Assert.assertEquals((long)1L, (long)data[0]);
        Assert.assertEquals((long)0L, (long)data[1]);
    }

    @Test
    public void testGetBytesMiddle() throws CTFException {
        byte @NonNull [] data = new byte[5];
        this.fixture = new BitBuffer(Util.testMemory(ByteBuffer.wrap(new String("hello world").getBytes())));
        this.fixture.position(48L);
        this.fixture.get(data);
        String actual = new String(data);
        Assert.assertEquals((Object)"world", (Object)actual);
    }
}

