/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.util;

import java.util.UUID;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.internal.ctf.core.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void testMakeUUID() throws CTFException {
        int byteSize = 32;
        byte[] bytes = new byte[byteSize];
        int i = 0;
        while (i < byteSize) {
            bytes[i] = (byte)i;
            ++i;
        }
        UUID result = Utils.makeUUID((byte[])bytes);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testMakeUUID_2() throws CTFException {
        byte[] byArray = new byte[16];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[8] = 1;
        byArray[9] = 1;
        byte[] bytes = byArray;
        UUID result = Utils.makeUUID((byte[])bytes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0x101000000000000L, (long)result.getLeastSignificantBits());
        Assert.assertEquals((long)0x101000000000000L, (long)result.getMostSignificantBits());
        Assert.assertEquals((Object)"01010000-0000-0000-0101-000000000000", (Object)result.toString());
        Assert.assertEquals((long)0L, (long)result.variant());
        Assert.assertEquals((long)0L, (long)result.version());
    }

    @Test
    public void testMakeUUID_3() throws CTFException {
        byte[] bytes = new byte[16];
        UUID result = Utils.makeUUID((byte[])bytes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getLeastSignificantBits());
        Assert.assertEquals((long)0L, (long)result.getMostSignificantBits());
        Assert.assertEquals((Object)"00000000-0000-0000-0000-000000000000", (Object)result.toString());
        Assert.assertEquals((long)0L, (long)result.variant());
        Assert.assertEquals((long)0L, (long)result.version());
    }

    @Test
    public void testUnsignedCompare() {
        long a = 1L;
        long b = 1L;
        int result = Utils.unsignedCompare((long)a, (long)b);
        Assert.assertEquals((long)0L, (long)result);
        result = Utils.unsignedCompare((long)0L, (long)1L);
        Assert.assertEquals((long)-1L, (long)result);
        result = Utils.unsignedCompare((long)0xFFFFFFFFL, (long)0x100000000L);
        Assert.assertEquals((long)-1L, (long)result);
        result = Utils.unsignedCompare((long)-4L, (long)-1L);
        Assert.assertEquals((long)-1L, (long)result);
        result = Utils.unsignedCompare((long)Integer.MIN_VALUE, (long)-1L);
        Assert.assertEquals((long)-1L, (long)result);
        result = Utils.unsignedCompare((long)0x7FFFFFFFFFFFFFFEL, (long)Long.MAX_VALUE);
        Assert.assertEquals((long)-1L, (long)result);
        result = Utils.unsignedCompare((long)1L, (long)0L);
        Assert.assertEquals((long)1L, (long)result);
        result = Utils.unsignedCompare((long)0x100000000L, (long)0xFFFFFFFFL);
        Assert.assertEquals((long)1L, (long)result);
        result = Utils.unsignedCompare((long)-1L, (long)-4L);
        Assert.assertEquals((long)1L, (long)result);
        result = Utils.unsignedCompare((long)-1L, (long)Integer.MIN_VALUE);
        Assert.assertEquals((long)1L, (long)result);
        result = Utils.unsignedCompare((long)Long.MAX_VALUE, (long)0x7FFFFFFFFFFFFFFEL);
        Assert.assertEquals((long)1L, (long)result);
    }
}

