/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui;

import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.trace4cps.common.jfreechart.ui.theme.ChartThemeSupplier;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.osgi.framework.BundleContext;

public class JFreeChartUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.trace4cps.common.jfreechart.ui";
    private static final String EXTENSION_CHART_THEME_SUPPLIER = "org.eclipse.trace4cps.common.jfreechart.ui.chartthemesupplier";
    private static JFreeChartUIPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.configureLookAndFeel();
        this.configureChartThemeSupplier();
    }

    private void configureLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            Status status = new Status(4, PLUGIN_ID, "Failed to install system look-and-feel: " + e.getLocalizedMessage(), (Throwable)e);
            this.getLog().log((IStatus)status);
        }
    }

    private void configureChartThemeSupplier() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_CHART_THEME_SUPPLIER);
        int highestRank = Integer.MIN_VALUE;
        IConfigurationElement highestElement = null;
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("chart_theme_supplier".equals(element.getName())) {
                String rankStr = element.getAttribute("rank");
                if (rankStr == null) {
                    Status status = new Status(4, element.getContributor().getName(), "Chart theme supplier is missing mandatory attribute 'rank'");
                    this.getLog().log((IStatus)status);
                }
                try {
                    int rank = Integer.parseInt(rankStr);
                    if (rank >= highestRank) {
                        highestRank = rank;
                        highestElement = element;
                    }
                }
                catch (NumberFormatException e) {
                    Status status = new Status(4, element.getContributor().getName(), "Chart theme supplier attribute 'rank' not a valid integer", (Throwable)e);
                    this.getLog().log((IStatus)status);
                }
            }
            ++n2;
        }
        if (highestElement != null) {
            try {
                ChartThemeSupplier supplier = (ChartThemeSupplier)highestElement.createExecutableExtension("class");
                ChartFactory.setChartTheme((ChartTheme)supplier.getChartTheme());
            }
            catch (CoreException e) {
                Status status = new Status(4, highestElement.getContributor().getName(), "Chart theme supplier could not be instantiated", (Throwable)e);
                this.getLog().log((IStatus)status);
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static JFreeChartUIPlugin getDefault() {
        return plugin;
    }
}

