/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.utils;

import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.languageconfiguration.internal.model.CursorConfiguration;

public final class TextUtils {
    public static boolean isEnter(IDocument doc, DocumentCommand cmd) {
        return cmd.length == 0 && cmd.text != null && TextUtils.isLegalLineDelimiter(doc, cmd.text);
    }

    private static boolean isLegalLineDelimiter(IDocument doc, String delimiter) {
        if (delimiter.length() > 2) {
            return false;
        }
        String[] stringArray = doc.getLegalLineDelimiters();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String d = stringArray[n2];
            if (d.equals(delimiter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getIndentationFromWhitespace(String whitespace, CursorConfiguration cursorCfg) {
        String tab = "\t";
        int indentOffset = 0;
        boolean startsWithTab = true;
        boolean startsWithSpaces = true;
        String spaces = cursorCfg.insertSpaces ? " ".repeat(cursorCfg.indentSize) : "";
        while (startsWithTab || startsWithSpaces) {
            startsWithTab = whitespace.startsWith("\t", indentOffset);
            boolean bl = startsWithSpaces = cursorCfg.insertSpaces && whitespace.startsWith(spaces, indentOffset);
            if (startsWithTab) {
                indentOffset += "\t".length();
            }
            if (!startsWithSpaces) continue;
            indentOffset += spaces.length();
        }
        return whitespace.substring(0, indentOffset);
    }

    public static String getIndentationAtPosition(IDocument doc, int offset) {
        try {
            int lineStartOffset = doc.getLineInformationOfOffset(offset).getOffset();
            int indentationEndOffset = TextUtils.findEndOfWhiteSpace(doc, lineStartOffset, offset);
            return doc.get(lineStartOffset, indentationEndOffset - lineStartOffset);
        }
        catch (BadLocationException excp) {
            return "";
        }
    }

    private static int findEndOfWhiteSpace(IDocument doc, int startAt, int endAt) throws BadLocationException {
        int i = startAt;
        while (i < endAt) {
            char ch = doc.getChar(i);
            if (ch != ' ' && ch != '\t') {
                return i;
            }
            ++i;
        }
        return endAt;
    }

    public static String getLeadingWhitespace(IDocument doc, int lineIndex) throws BadLocationException {
        int lineStartOffset = doc.getLineOffset(lineIndex);
        int lineLength = doc.getLineLength(lineIndex);
        return doc.get(lineStartOffset, TextUtils.findEndOfWhiteSpace(doc, lineStartOffset, lineStartOffset + lineLength) - lineStartOffset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isBlankLine(IDocument doc, int lineIndex) {
        try {
            int offset = doc.getLineOffset(lineIndex);
            int lineEnd = offset + doc.getLineLength(lineIndex);
            while (true) {
                if (offset >= lineEnd) {
                    return true;
                }
                if (!Character.isWhitespace(doc.getChar(offset))) {
                    return false;
                }
                ++offset;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return true;
    }

    public static boolean isEmptyLine(IDocument doc, int lineIndex) {
        int lineLength;
        block5: {
            block4: {
                try {
                    lineLength = doc.getLineLength(lineIndex);
                    if (lineLength <= 2) break block4;
                    return false;
                }
                catch (BadLocationException e) {
                    return true;
                }
            }
            if (lineLength != 0) break block5;
            return true;
        }
        int lineOffset = doc.getLineOffset(lineIndex);
        return TextUtils.isLegalLineDelimiter(doc, doc.get(lineOffset, lineLength));
    }

    public static CharSequence replaceIndent(CharSequence multiLineString, int tabSize, String newIndent, boolean indentEmptyLines) {
        int existingIndent;
        int effectiveTabSize = Math.max(1, tabSize);
        final class IndentDetector
        extends 1CharConsumer
        implements IntPredicate {
            int existingIndent = Integer.MAX_VALUE;
            int indentOfLine = 0;
            boolean isEmptyLine = true;
            boolean skipToLineEnd = false;
            int lineCount = 1;
            private final /* synthetic */ int val$effectiveTabSize;

            IndentDetector(int n) {
                this.val$effectiveTabSize = n;
                abstract class CharConsumer
                implements IntConsumer {
                    char prevChar = '\u0000';

                    CharConsumer() {
                    }

                    @Override
                    public void accept(int value) {
                        char ch = (char)value;
                        this.onChar(ch);
                        this.prevChar = ch;
                    }

                    abstract void onChar(char var1);
                }
            }

            @Override
            void onChar(char ch) {
                if (ch == '\n' || ch == '\r') {
                    if (ch == '\n' && this.prevChar == '\r' || ch == '\r' && this.prevChar == '\n') {
                        return;
                    }
                    ++this.lineCount;
                    this.skipToLineEnd = false;
                    if (!this.isEmptyLine && this.indentOfLine < this.existingIndent) {
                        this.existingIndent = this.indentOfLine;
                    }
                    this.indentOfLine = 0;
                    this.isEmptyLine = true;
                    return;
                }
                this.isEmptyLine = false;
                if (!this.skipToLineEnd) {
                    if (ch == '\t') {
                        this.indentOfLine += this.val$effectiveTabSize;
                    } else if (Character.isWhitespace(ch)) {
                        ++this.indentOfLine;
                    } else {
                        this.skipToLineEnd = true;
                    }
                }
            }

            @Override
            public boolean test(int value) {
                return this.existingIndent > 0;
            }
        }
        IndentDetector indentDetector = new IndentDetector(effectiveTabSize);
        multiLineString.chars().takeWhile(indentDetector).forEach(indentDetector);
        int n = existingIndent = indentDetector.isEmptyLine ? indentDetector.existingIndent : Math.min(indentDetector.indentOfLine, indentDetector.existingIndent);
        if (existingIndent == 0 && newIndent.isEmpty()) {
            return multiLineString;
        }
        StringBuilder sb = new StringBuilder(Math.max(0, multiLineString.length() - indentDetector.lineCount * existingIndent));
        final class IdentReplacer
        extends 1CharConsumer {
            int skippedIndentOfLine = 0;
            boolean isEmptyLine = true;
            private final /* synthetic */ boolean val$indentEmptyLines;
            private final /* synthetic */ StringBuilder val$sb;
            private final /* synthetic */ String val$newIndent;
            private final /* synthetic */ int val$existingIndent;
            private final /* synthetic */ int val$effectiveTabSize;

            IdentReplacer(boolean bl, StringBuilder stringBuilder, String string, int n, int n2) {
                this.val$indentEmptyLines = bl;
                this.val$sb = stringBuilder;
                this.val$newIndent = string;
                this.val$existingIndent = n;
                this.val$effectiveTabSize = n2;
            }

            @Override
            public void onChar(char ch) {
                if (ch == '\r') {
                    return;
                }
                if (ch == '\n') {
                    if (this.isEmptyLine && this.val$indentEmptyLines) {
                        this.val$sb.append(this.val$newIndent);
                    }
                    if (this.prevChar == '\r') {
                        this.val$sb.append('\r');
                    }
                    this.val$sb.append(ch);
                    this.skippedIndentOfLine = 0;
                    this.isEmptyLine = true;
                    return;
                }
                if (this.skippedIndentOfLine >= this.val$existingIndent) {
                    if (this.isEmptyLine) {
                        this.val$sb.append(this.val$newIndent);
                        this.isEmptyLine = false;
                    }
                    this.val$sb.append(ch);
                } else {
                    this.skippedIndentOfLine = ch == '\t' ? (this.skippedIndentOfLine += this.val$effectiveTabSize) : ++this.skippedIndentOfLine;
                }
            }
        }
        IdentReplacer indentReplacer = new IdentReplacer(indentEmptyLines, sb, newIndent, existingIndent, effectiveTabSize);
        multiLineString.chars().forEach(indentReplacer);
        if (indentEmptyLines && sb.isEmpty() && !multiLineString.isEmpty()) {
            sb.append(newIndent);
        }
        return sb;
    }

    private TextUtils() {
    }
}

