/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.widgets;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationMessages;
import org.eclipse.tm4e.languageconfiguration.internal.model.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.model.CommentRule;
import org.eclipse.tm4e.languageconfiguration.internal.model.FoldingRules;
import org.eclipse.tm4e.languageconfiguration.internal.model.IndentationRules;
import org.eclipse.tm4e.languageconfiguration.internal.model.LanguageConfiguration;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.AutoClosingPairConditionalTableWidget;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.CharacterPairsTableWidget;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.OnEnterRuleTableWidget;

public class LanguageConfigurationInfoWidget
extends Composite {
    private final String[] tabs = new String[]{LanguageConfigurationMessages.LanguageConfigurationInfoWidget_comments_title, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_brackets_title, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_autoClosingPairs_title, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_autoCloseBefore_title, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_surroundingPairs_title, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_folding_title, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_wordPattern_title, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_onEnterRules_title, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_indentationRules_title, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_colorizedBracketPairs_title};
    private Text lineCommentText = (Text)NullSafetyHelper.lazyNonNull();
    private Text blockCommentStartText = (Text)NullSafetyHelper.lazyNonNull();
    private Text blockCommentEndText = (Text)NullSafetyHelper.lazyNonNull();
    private CharacterPairsTableWidget bracketsTable = (CharacterPairsTableWidget)((Object)NullSafetyHelper.lazyNonNull());
    private AutoClosingPairConditionalTableWidget autoClosingPairsTable = (AutoClosingPairConditionalTableWidget)((Object)NullSafetyHelper.lazyNonNull());
    private Text autoCloseBeforeText = (Text)NullSafetyHelper.lazyNonNull();
    private CharacterPairsTableWidget surroundingPairsTable = (CharacterPairsTableWidget)((Object)NullSafetyHelper.lazyNonNull());
    private Text foldingOffsideText = (Text)NullSafetyHelper.lazyNonNull();
    private Text foldingMarkersStartText = (Text)NullSafetyHelper.lazyNonNull();
    private Text foldingMarkersEndText = (Text)NullSafetyHelper.lazyNonNull();
    private Text wordPatternText = (Text)NullSafetyHelper.lazyNonNull();
    private OnEnterRuleTableWidget onEnterRuleTable = (OnEnterRuleTableWidget)((Object)NullSafetyHelper.lazyNonNull());
    private Text indentationDecreaseIndentPattern = (Text)NullSafetyHelper.lazyNonNull();
    private Text indentationIncreaseIndentPattern = (Text)NullSafetyHelper.lazyNonNull();
    private Text indentationIndentNextLinePattern = (Text)NullSafetyHelper.lazyNonNull();
    private Text indentationUnIndentedLinePattern = (Text)NullSafetyHelper.lazyNonNull();
    private CharacterPairsTableWidget colorizedBracketPairsTable = (CharacterPairsTableWidget)((Object)NullSafetyHelper.lazyNonNull());

    public LanguageConfigurationInfoWidget(Composite parent, int style) {
        super(parent, style);
        super.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).spacing(-1, 0).equalWidth(false).create());
        super.setLayoutData((Object)new GridData(1808));
        this.createUI(this);
    }

    private void createUI(Composite parent) {
        TableViewer tableViewer = new TableViewer(parent, 2064);
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput((Object)this.tabs);
        Table table = tableViewer.getTable();
        GC gc = new GC((Drawable)table.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        int maxLabelWidth = 0;
        String[] stringArray = this.tabs;
        int n = this.tabs.length;
        int n2 = 0;
        while (n2 < n) {
            String tab = stringArray[n2];
            int width = gc.stringExtent((String)tab).x;
            if (width > maxLabelWidth) {
                maxLabelWidth = width;
            }
            ++n2;
        }
        gc.dispose();
        GridData gd = new GridData(4, 4, false, false);
        gd.widthHint = maxLabelWidth += 10;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TableColumn column = new TableColumn(table, 0);
        column.setWidth(maxLabelWidth);
        column.setResizable(false);
        StackLayout stackLayout = new StackLayout();
        Composite stack = new Composite(parent, 4);
        stack.setLayout((Layout)stackLayout);
        stack.setLayoutData((Object)new GridData(4, 4, true, true));
        Function<Consumer, Composite> createStackLayer = layerDecorator -> {
            Composite layer = new Composite(stack, 2048);
            layer.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
            layer.setBackground(this.getDisplay().getSystemColor(25));
            layer.setBackgroundMode(1);
            layerDecorator.accept(layer);
            return layer;
        };
        Composite[] stackLayers = new Composite[]{createStackLayer.apply(this::createCommentsInfo), createStackLayer.apply(this::createBracketsInfo), createStackLayer.apply(this::createAutoClosingPairsInfo), createStackLayer.apply(this::createAutoCloseBeforeInfo), createStackLayer.apply(this::createSurroundingPairsInfo), createStackLayer.apply(this::createFoldingInfo), createStackLayer.apply(this::createWordPatternInfo), createStackLayer.apply(this::createOnEnterRulesInfo), createStackLayer.apply(this::createIndentationRulesInfo), createStackLayer.apply(this::createColorizedBracketPairsInfo)};
        tableViewer.addSelectionChangedListener(event -> {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                stackLayout.topControl = stackLayers[table.getSelectionIndex()];
                stack.layout();
            }
        });
        tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.tabs[0]));
    }

    public void refresh(@Nullable LanguageConfiguration configuration) {
        String wordPattern;
        this.lineCommentText.setText("");
        this.blockCommentStartText.setText("");
        this.blockCommentEndText.setText("");
        this.bracketsTable.setInput(null);
        this.autoClosingPairsTable.setInput(null);
        this.autoCloseBeforeText.setText("");
        this.surroundingPairsTable.setInput(null);
        this.foldingOffsideText.setText("");
        this.foldingMarkersStartText.setText("");
        this.foldingMarkersEndText.setText("");
        this.wordPatternText.setText("");
        this.onEnterRuleTable.setInput(null);
        this.indentationDecreaseIndentPattern.setText("");
        this.indentationIncreaseIndentPattern.setText("");
        this.indentationIndentNextLinePattern.setText("");
        this.indentationUnIndentedLinePattern.setText("");
        this.colorizedBracketPairsTable.setInput(null);
        if (configuration == null) {
            return;
        }
        CommentRule comments = configuration.getComments();
        if (comments != null) {
            this.lineCommentText.setText(Objects.toString(comments.lineComment, ""));
            CharacterPair blockComment = comments.blockComment;
            if (blockComment != null) {
                this.blockCommentStartText.setText(blockComment.open);
                this.blockCommentEndText.setText(blockComment.close);
            }
        }
        this.bracketsTable.setInput(configuration.getBrackets());
        this.autoClosingPairsTable.setInput(configuration.getAutoClosingPairs());
        String autoCloseBefore = configuration.getAutoCloseBefore();
        if (autoCloseBefore != null) {
            this.autoCloseBeforeText.setText(autoCloseBefore);
        }
        this.surroundingPairsTable.setInput(configuration.getSurroundingPairs());
        FoldingRules folding = configuration.getFolding();
        if (folding != null) {
            this.foldingOffsideText.setText(Boolean.toString(folding.offSide));
            this.foldingMarkersStartText.setText(folding.markers.start.pattern());
            this.foldingMarkersEndText.setText(folding.markers.end.pattern());
        }
        if ((wordPattern = configuration.getWordPattern()) != null) {
            this.wordPatternText.setText(wordPattern);
        }
        this.onEnterRuleTable.setInput(configuration.getOnEnterRules());
        IndentationRules indentationRules = configuration.getIndentationRules();
        if (indentationRules != null) {
            this.indentationDecreaseIndentPattern.setText(indentationRules.decreaseIndentPattern.toString());
            this.indentationIncreaseIndentPattern.setText(indentationRules.increaseIndentPattern.toString());
            this.indentationIndentNextLinePattern.setText(Objects.toString(indentationRules.indentNextLinePattern, ""));
            this.indentationUnIndentedLinePattern.setText(Objects.toString(indentationRules.unIndentedLinePattern, ""));
        }
        this.colorizedBracketPairsTable.setInput(configuration.getColorizedBracketPairs());
    }

    private void createCommentsInfo(Composite parent) {
        this.lineCommentText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_lineComments);
        this.blockCommentStartText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_blockCommentsStart);
        this.blockCommentEndText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_blockCommentsEnd);
    }

    private void createBracketsInfo(Composite parent) {
        this.bracketsTable = new CharacterPairsTableWidget(parent);
    }

    protected void createAutoClosingPairsInfo(Composite parent) {
        this.autoClosingPairsTable = new AutoClosingPairConditionalTableWidget(parent);
    }

    private void createAutoCloseBeforeInfo(Composite parent) {
        this.autoCloseBeforeText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_autoCloseBefore_message);
    }

    protected void createSurroundingPairsInfo(Composite parent) {
        this.surroundingPairsTable = new CharacterPairsTableWidget(parent);
    }

    private void createFoldingInfo(Composite parent) {
        this.foldingOffsideText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_offSide);
        this.foldingOffsideText.setToolTipText(LanguageConfigurationMessages.LanguageConfigurationInfoWidget_offSide_tooltip);
        new Label(parent, 0).setText(LanguageConfigurationMessages.LanguageConfigurationInfoWidget_markers);
        this.foldingMarkersStartText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_start);
        this.foldingMarkersEndText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_end);
    }

    private void createWordPatternInfo(Composite parent) {
        this.wordPatternText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_wordPattern_message);
    }

    protected void createOnEnterRulesInfo(Composite parent) {
        this.onEnterRuleTable = new OnEnterRuleTableWidget(parent);
    }

    protected void createIndentationRulesInfo(Composite parent) {
        this.indentationDecreaseIndentPattern = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_indentationRules_decreaseIndentPattern);
        this.indentationIncreaseIndentPattern = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_indentationRules_increaseIndentPattern);
        this.indentationIndentNextLinePattern = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_indentationRules_indentNextLinePattern);
        this.indentationUnIndentedLinePattern = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_indentationRules_unIndentedLinePattern);
    }

    private void createColorizedBracketPairsInfo(Composite parent) {
        this.colorizedBracketPairsTable = new CharacterPairsTableWidget(parent);
    }

    private Text createText(Composite parent, String s) {
        Label label = new Label(parent, 0);
        label.setText(s);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setEditable(false);
        return text;
    }
}

