/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.preferences;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.preferences.AbstractPreferencePage;
import org.eclipse.tm4e.ui.internal.themes.ThemeManager;
import org.eclipse.tm4e.ui.internal.widgets.ContentTypesBindingWidget;
import org.eclipse.tm4e.ui.internal.widgets.GrammarInfoWidget;
import org.eclipse.tm4e.ui.internal.widgets.TMViewer;
import org.eclipse.tm4e.ui.internal.widgets.TableWidget;
import org.eclipse.tm4e.ui.internal.widgets.TableWithControlsWidget;
import org.eclipse.tm4e.ui.internal.widgets.ThemeAssociationsWidget;
import org.eclipse.tm4e.ui.internal.widgets.VerticalSplitPane;
import org.eclipse.tm4e.ui.internal.wizards.TextMateGrammarImportWizard;
import org.eclipse.tm4e.ui.snippets.ISnippet;
import org.eclipse.tm4e.ui.snippets.ISnippetManager;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.osgi.service.prefs.BackingStoreException;

public final class GrammarPreferencePage
extends AbstractPreferencePage {
    static final String PAGE_ID = "org.eclipse.tm4e.ui.preferences.GrammarPreferencePage";
    private IGrammarRegistryManager.EditSession grammarManager = TMEclipseRegistryPlugin.getGrammarRegistryManager().newEditSession();
    private IThemeManager.EditSession themeManager = ThemeManager.getInstance().newEditSession();
    private ISnippetManager snippetManager = TMUIPlugin.getSnippetManager();
    private TableWidget<IGrammarDefinition> grammarsTable = (TableWidget)((Object)NullSafetyHelper.lazyNonNull());
    private GrammarInfoWidget grammarInfoWidget = (GrammarInfoWidget)((Object)NullSafetyHelper.lazyNonNull());
    private ContentTypesBindingWidget contentTypesWidget = (ContentTypesBindingWidget)((Object)NullSafetyHelper.lazyNonNull());
    private ThemeAssociationsWidget themeAssociationsWidget = (ThemeAssociationsWidget)((Object)NullSafetyHelper.lazyNonNull());
    private TMViewer grammarPreview = (TMViewer)((Object)NullSafetyHelper.lazyNonNull());

    public GrammarPreferencePage() {
        super(TMUIMessages.GrammarPreferencePage_title, TMUIMessages.GrammarPreferencePage_description);
    }

    protected Control createContents(@NonNullByDefault(value={}) Composite parent) {
        Control control = new VerticalSplitPane(parent, 1, 1){

            @Override
            protected void configureUpperArea(Composite parent) {
                GrammarPreferencePage.this.createGrammarsTable(parent);
            }

            @Override
            protected void configureLowerArea(Composite parent) {
                GrammarPreferencePage.this.createGrammarDetailsView(parent);
                GrammarPreferencePage.this.createThemePreview(parent);
            }
        }.getControl();
        Dialog.applyDialogFont((Control)control);
        this.grammarsTable.setInput(this.grammarManager);
        this.grammarsTable.selectFirstRow();
        return control;
    }

    private void createGrammarsTable(Composite parent) {
        TableWithControlsWidget<IGrammarDefinition> tableWithControls = new TableWithControlsWidget<IGrammarDefinition>(parent, null, true){

            @Override
            protected TableWidget<IGrammarDefinition> createTable(Composite parent) {
                return new TableWidget<IGrammarDefinition>(parent, false){

                    @Override
                    protected void createColumns() {
                        this.createAutoResizeColumn(TMUIMessages.GrammarPreferencePage_column_contentTypes, 1);
                        this.createAutoResizeColumn(TMUIMessages.GrammarPreferencePage_column_scopeName, 2);
                        this.createAutoResizeColumn(TMUIMessages.GrammarPreferencePage_column_source, 0, 1);
                    }

                    protected @Nullable String getColumnText(IGrammarDefinition def, int columnIndex) {
                        return switch (columnIndex) {
                            case 0 -> {
                                Collection contentTypes = (this).GrammarPreferencePage.this.grammarManager.getContentTypesForScope(def.getScope());
                                if (contentTypes == null) {
                                    yield null;
                                }
                                yield contentTypes.stream().map(ct -> ct.getName()).distinct().sorted().collect(Collectors.joining(", "));
                            }
                            case 1 -> def.getScope().getName();
                            case 2 -> (String)(def.getPluginId() == null ? "" : def.getPluginId() + " > ") + def.getPath();
                            default -> null;
                        };
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected Object[] getElements(@Nullable Object input) {
                        Object object = input;
                        if (object instanceof IGrammarRegistryManager) {
                            void manager;
                            IGrammarRegistryManager iGrammarRegistryManager = (IGrammarRegistryManager)object;
                            IGrammarRegistryManager cfr_ignored_0 = (IGrammarRegistryManager)object;
                            return manager.getDefinitions();
                        }
                        return super.getElements(input);
                    }
                };
            }

            @Override
            protected void createButtons() {
                this.createButton(TMUIMessages.Button_new, () -> {
                    TextMateGrammarImportWizard wizard = new TextMateGrammarImportWizard(GrammarPreferencePage.this.grammarManager, false);
                    WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                    if (dialog.open() == 0) {
                        IGrammarDefinition created = wizard.getCreatedDefinition();
                        this.table.refresh();
                        this.table.setSelection(true, (T[])new IGrammarDefinition[]{created});
                    }
                });
                Button removeBtn = this.createButton(TMUIMessages.Button_remove, () -> {
                    IGrammarDefinition definition = (IGrammarDefinition)this.table.getFirstSelectedElement();
                    if (definition != null) {
                        GrammarPreferencePage.this.grammarManager.unregisterGrammarDefinition(definition);
                        this.table.refresh();
                    }
                });
                this.table.onSelectionChanged(sel -> removeBtn.setEnabled(!sel.isEmpty() && ((IGrammarDefinition)sel.get(0)).getPluginId() == null));
            }
        };
        tableWithControls.setLayoutData(GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(360, this.convertHeightInCharsToPixels(10)).create());
        this.grammarsTable = tableWithControls.getTable();
        this.grammarsTable.onSelectionChanged(selectedGrammarDefinitions -> {
            if (!selectedGrammarDefinitions.isEmpty()) {
                this.selectGrammar((IGrammarDefinition)selectedGrammarDefinitions.get(0));
            }
        });
    }

    private void createGrammarDetailsView(Composite parent) {
        TabFolder folder = new TabFolder(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        folder.setLayoutData((Object)gd);
        this.createGeneralTab(folder);
        this.createContentTypeTab(folder);
        this.createThemeTab(folder);
        this.createInjectionTab(folder);
    }

    private void createGeneralTab(TabFolder folder) {
        TabItem tab = new TabItem(folder, 0);
        tab.setText(TMUIMessages.GrammarPreferencePage_tab_general_text);
        Composite parent = new Composite((Composite)folder, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(768));
        this.grammarInfoWidget = new GrammarInfoWidget(parent, 0);
        this.grammarInfoWidget.setLayoutData(new GridData(768));
        tab.setControl((Control)parent);
    }

    private void createContentTypeTab(TabFolder folder) {
        TabItem tab = new TabItem(folder, 0);
        tab.setText(TMUIMessages.GrammarPreferencePage_tab_contentType_text);
        Composite parent = new Composite((Composite)folder, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(768));
        this.contentTypesWidget = new ContentTypesBindingWidget(parent, 0);
        this.contentTypesWidget.setLayoutData(new GridData(768));
        tab.setControl((Control)parent);
    }

    private void createThemeTab(TabFolder folder) {
        TabItem tab = new TabItem(folder, 0);
        tab.setText(TMUIMessages.GrammarPreferencePage_tab_theme_text);
        Composite parent = new Composite((Composite)folder, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(768));
        this.themeAssociationsWidget = new ThemeAssociationsWidget(this.themeManager, parent, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.themeAssociationsWidget.setLayoutData(data);
        this.themeAssociationsWidget.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(@Nullable SelectionChangedEvent e) {
                if (e == null) {
                    return;
                }
                IThemeAssociation association = (IThemeAssociation)((IStructuredSelection)e.getSelection()).getFirstElement();
                this.selectTheme(association);
            }

            private void selectTheme(@Nullable IThemeAssociation association) {
                GrammarPreferencePage.this.themeAssociationsWidget.getNewButton().setEnabled(association != null);
                GrammarPreferencePage.this.themeAssociationsWidget.getRemoveButton().setEnabled(association != null);
                if (association != null) {
                    GrammarPreferencePage.this.setPreviewTheme(association.getThemeId());
                }
            }
        });
        tab.setControl((Control)parent);
        this.grammarsTable.onSelectionChanged(selectedGrammarDefinitions -> {
            this.themeAssociationsWidget.getNewButton().setEnabled(false);
            this.themeAssociationsWidget.getRemoveButton().setEnabled(false);
        });
    }

    private void setPreviewTheme(String themeId) {
        ITheme theme = this.themeManager.getThemeById(themeId);
        if (theme != null) {
            this.grammarPreview.setTheme(theme);
        }
    }

    private void createInjectionTab(TabFolder folder) {
        TabItem tab = new TabItem(folder, 0);
        tab.setText(TMUIMessages.GrammarPreferencePage_tab_injection_text);
        Composite parent = new Composite((Composite)folder, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(768));
        tab.setControl((Control)parent);
    }

    private void selectGrammar(IGrammarDefinition definition) {
        this.fillGeneralTab(definition);
        this.fillContentTypeTab(definition);
        IThemeAssociation selectedAssociation = this.fillThemeTab(definition);
        this.preview(definition, selectedAssociation);
    }

    private void fillGeneralTab(IGrammarDefinition definition) {
        IGrammar grammar = this.grammarManager.getGrammarForScope(definition.getScope());
        this.grammarInfoWidget.refresh(grammar);
    }

    private void fillContentTypeTab(IGrammarDefinition definition) {
        this.contentTypesWidget.setInput(this.grammarManager.getContentTypesForScope(definition.getScope()));
    }

    private @Nullable IThemeAssociation fillThemeTab(IGrammarDefinition definition) {
        IThemeAssociation selectedAssociation = null;
        IStructuredSelection oldSelection = this.themeAssociationsWidget.getSelection();
        IThemeAssociation[] themeAssociations = this.themeAssociationsWidget.setGrammarDefinition(definition);
        if (!oldSelection.isEmpty() && Arrays.asList(themeAssociations).contains(oldSelection.getFirstElement())) {
            selectedAssociation = (IThemeAssociation)oldSelection.getFirstElement();
            this.themeAssociationsWidget.setSelection(oldSelection);
        } else {
            IThemeAssociation iThemeAssociation = selectedAssociation = themeAssociations.length > 0 ? themeAssociations[0] : null;
            if (selectedAssociation != null) {
                this.themeAssociationsWidget.setSelection((IStructuredSelection)new StructuredSelection((Object)selectedAssociation));
            }
        }
        return selectedAssociation;
    }

    private void createThemePreview(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(TMUIMessages.GrammarPreferencePage_preview);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.grammarPreview = new TMViewer(parent, null, null, false, 2816);
        Control control = this.grammarPreview.getControl();
        control.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, this.convertHeightInCharsToPixels(5)).create());
    }

    private void preview(IGrammarDefinition definition, @Nullable IThemeAssociation selectedAssociation) {
        IGrammar grammar = this.grammarManager.getGrammarForScope(definition.getScope());
        if (selectedAssociation != null) {
            this.setPreviewTheme(selectedAssociation.getThemeId());
        }
        this.grammarPreview.setGrammar(grammar);
        ISnippet[] snippets = this.snippetManager.getSnippets(definition.getScope().getName());
        if (snippets.length == 0) {
            this.grammarPreview.setText("");
        } else {
            this.grammarPreview.setText(snippets[0].getContent());
        }
    }

    protected void performDefaults() {
        this.grammarManager = TMEclipseRegistryPlugin.getGrammarRegistryManager().newEditSession();
        this.themeManager = ThemeManager.getInstance().newEditSession();
        this.grammarsTable.setInput(this.themeManager);
    }

    public boolean performOk() {
        try {
            this.grammarManager.save();
            this.themeManager.save();
        }
        catch (BackingStoreException ex) {
            TMUIPlugin.logError((Exception)((Object)ex));
            return false;
        }
        return super.performOk();
    }
}

