/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import java.util.Vector;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAFileTypesForName;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeManager;

public class SystemUDAResolvedTypes {
    protected Vector previousTypes = null;
    protected Vector[] UDAFileTypesForNameByDomain;
    protected Vector UDAFileTypesForNameNoDomain;

    protected void addTypesToVector(Vector v, Object[] objElems) {
        int i = 0;
        while (i < objElems.length) {
            SystemUDTypeElement typeElem = (SystemUDTypeElement)objElems[i];
            String name = typeElem.toString();
            this.resolveType(name, v, objElems);
            ++i;
        }
    }

    protected String resolveTypes(String types, Vector v, Object[] objElems) {
        int i = types.indexOf("<");
        if (i < 0) {
            return types;
        }
        int j = types.indexOf(">");
        if (i >= j) {
            return types;
        }
        String type = types.substring(i + 1, j);
        String resolvedType = this.resolveType(type, v, objElems);
        return String.valueOf(types.substring(0, i)) + " " + resolvedType + " " + this.resolveTypes(types.substring(j + 1), v, objElems);
    }

    protected String resolveType(String type, Vector v, Object[] objElems) {
        if (this.previousTypes.contains(type)) {
            return "";
        }
        String resolvedTypes = this.resolveType(type, v);
        if (resolvedTypes != null) {
            return resolvedTypes;
        }
        int i = 0;
        while (i < objElems.length) {
            SystemUDTypeElement typeElem = (SystemUDTypeElement)objElems[i];
            if (type.equals(typeElem.toString())) {
                this.previousTypes.addElement(type);
                String types = typeElem.getTypes();
                if (types != null) {
                    resolvedTypes = this.resolveTypes(types, v, objElems);
                }
                this.previousTypes.remove(type);
                v.addElement(new SystemUDAFileTypesForName(type, resolvedTypes));
                return resolvedTypes;
            }
            ++i;
        }
        return "";
    }

    protected String resolveType(String type, Vector v) {
        int i = 0;
        while (i < v.size()) {
            SystemUDAFileTypesForName typesForName = (SystemUDAFileTypesForName)v.elementAt(i);
            if (type.equals(typesForName.getName())) {
                return typesForName.getTypes();
            }
            ++i;
        }
        return null;
    }

    public String getFileTypesForTypeName(String name, int domain, SystemUDTypeManager typeMgr) {
        Vector typesVector = null;
        boolean supportsDomains = typeMgr.getActionSubSystem().supportsDomains();
        boolean needToPopulate = false;
        if (supportsDomains) {
            if (this.UDAFileTypesForNameByDomain == null) {
                int nbrDomains = typeMgr.getActionSubSystem().getMaximumDomain() + 1;
                this.UDAFileTypesForNameByDomain = new Vector[nbrDomains];
            }
            if ((typesVector = this.UDAFileTypesForNameByDomain[domain]) == null) {
                this.UDAFileTypesForNameByDomain[domain] = typesVector = new Vector();
                needToPopulate = true;
            }
        } else {
            typesVector = this.UDAFileTypesForNameNoDomain;
            if (typesVector == null) {
                this.UDAFileTypesForNameNoDomain = typesVector = new Vector();
                needToPopulate = true;
            }
        }
        if (needToPopulate) {
            this.previousTypes = new Vector();
            this.addTypesToVector(typesVector, typeMgr.getTypes(null, domain));
        }
        return this.resolveType(name, typesVector);
    }
}

