"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphUnitController = void 0;
var TimeGraphUnitController = /** @class */ (function () {
    function TimeGraphUnitController(absoluteRange, viewRange) {
        this.absoluteRange = absoluteRange;
        this._offset = BigInt(0);
        this.viewRangeChangedHandlers = [];
        this._viewRange = viewRange || { start: BigInt(0), end: absoluteRange };
        this.selectionRangeChangedHandlers = [];
    }
    TimeGraphUnitController.prototype.handleViewRangeChange = function () {
        var _this = this;
        this.viewRangeChangedHandlers.forEach(function (handler) { return handler(_this._viewRange); });
    };
    TimeGraphUnitController.prototype.handleSelectionRangeChange = function () {
        var _this = this;
        this.selectionRangeChangedHandlers.forEach(function (handler) { return handler(_this._selectionRange); });
    };
    TimeGraphUnitController.prototype.onViewRangeChanged = function (handler) {
        this.viewRangeChangedHandlers.push(handler);
    };
    TimeGraphUnitController.prototype.removeViewRangeChangedHandler = function (handler) {
        var index = this.viewRangeChangedHandlers.indexOf(handler);
        if (index > -1) {
            this.viewRangeChangedHandlers.splice(index, 1);
        }
    };
    TimeGraphUnitController.prototype.onSelectionRangeChange = function (handler) {
        this.selectionRangeChangedHandlers.push(handler);
    };
    TimeGraphUnitController.prototype.removeSelectionRangeChangedHandler = function (handler) {
        var index = this.selectionRangeChangedHandlers.indexOf(handler);
        if (index > -1) {
            this.selectionRangeChangedHandlers.splice(index, 1);
        }
    };
    Object.defineProperty(TimeGraphUnitController.prototype, "viewRange", {
        get: function () {
            return this._viewRange;
        },
        set: function (newRange) {
            if (newRange.end > newRange.start) {
                this._viewRange = { start: newRange.start, end: newRange.end };
            }
            if (newRange.start < 0) {
                this._viewRange.start = BigInt(0);
            }
            if (this._viewRange.end > this.absoluteRange) {
                this._viewRange.end = this.absoluteRange;
            }
            this.handleViewRangeChange();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphUnitController.prototype, "selectionRange", {
        get: function () {
            return this._selectionRange;
        },
        set: function (value) {
            this._selectionRange = value;
            this.handleSelectionRangeChange();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphUnitController.prototype, "viewRangeLength", {
        get: function () {
            return this._viewRange.end - this._viewRange.start;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphUnitController.prototype, "offset", {
        get: function () {
            return this._offset;
        },
        set: function (offset) {
            this._offset = offset;
        },
        enumerable: false,
        configurable: true
    });
    return TimeGraphUnitController;
}());
exports.TimeGraphUnitController = TimeGraphUnitController;
//# sourceMappingURL=time-graph-unit-controller.js.map