"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphNavigatorBackground = exports.TimeGraphNavigatorHandle = exports.TimeGraphNavigator = void 0;
var time_graph_component_1 = require("../components/time-graph-component");
var time_graph_rectangle_1 = require("../components/time-graph-rectangle");
var time_graph_layer_1 = require("./time-graph-layer");
var bigint_utils_1 = require("../bigint-utils");
var TimeGraphNavigator = /** @class */ (function (_super) {
    __extends(TimeGraphNavigator, _super);
    function TimeGraphNavigator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TimeGraphNavigator.prototype.afterAddToContainer = function () {
        var _this = this;
        this._updateHandler = function () { return _this.update(); };
        this.unitController.onViewRangeChanged(this._updateHandler);
        this.navigatorBackground = new TimeGraphNavigatorBackground(this.unitController, this.stateController);
        this.addChild(this.navigatorBackground);
        this.navigatorHandle = new TimeGraphNavigatorHandle(this.unitController, this.stateController);
        this.addChild(this.navigatorHandle);
        this.unitController.onSelectionRangeChange(this._updateHandler);
        this.update();
    };
    TimeGraphNavigator.prototype.update = function () {
        this.navigatorHandle.clear();
        this.navigatorHandle.render();
        if (this.unitController.selectionRange) {
            var selectionOpts = {
                color: 0xb7b799,
                height: this.stateController.canvasDisplayHeight,
                opacity: 0.5,
                position: {
                    x: Number(this.unitController.selectionRange.start) * this.stateController.absoluteResolution,
                    y: 0
                },
                width: Number(this.unitController.selectionRange.end - this.unitController.selectionRange.start) * this.stateController.absoluteResolution
            };
            if (!this.selectionRange) {
                this.selectionRange = new time_graph_rectangle_1.TimeGraphRectangle(selectionOpts);
                this.addChild(this.selectionRange);
            }
            else {
                this.selectionRange.update(selectionOpts);
            }
        }
        else {
            if (this.selectionRange) {
                this.selectionRange.clear();
            }
        }
    };
    TimeGraphNavigator.prototype.destroy = function () {
        if (this.unitController) {
            this.unitController.removeViewRangeChangedHandler(this._updateHandler);
            this.unitController.removeSelectionRangeChangedHandler(this._updateHandler);
        }
        _super.prototype.destroy.call(this);
    };
    return TimeGraphNavigator;
}(time_graph_layer_1.TimeGraphLayer));
exports.TimeGraphNavigator = TimeGraphNavigator;
var TimeGraphNavigatorHandle = /** @class */ (function (_super) {
    __extends(TimeGraphNavigatorHandle, _super);
    function TimeGraphNavigatorHandle(unitController, stateController) {
        var _this = _super.call(this, 'navigator_handle') || this;
        _this.unitController = unitController;
        _this.stateController = stateController;
        var moveStart = function (event) {
            _this.mouseStartX = event.data.global.x;
            _this.oldViewStart = _this.unitController.viewRange.start;
            _this.mouseIsDown = true;
            _this.stateController.snapped = false;
            document.addEventListener('snap-x-end', _this._moveEndHandler);
        };
        _this._moveEndHandler = function () {
            _this.mouseIsDown = false;
            document.removeEventListener('snap-x-end', _this._moveEndHandler);
        };
        _this.addEvent('mouseover', function (event) {
            if (_this.stateController.snapped) {
                moveStart(event);
            }
        }, _this._displayObject);
        _this.addEvent('mousedown', moveStart, _this._displayObject);
        _this.addEvent('mousemove', function (event) {
            if (_this.mouseIsDown) {
                var delta = event.data.global.x - _this.mouseStartX;
                var start = bigint_utils_1.BIMath.clamp(Number(_this.oldViewStart) + (delta / _this.stateController.absoluteResolution), BigInt(0), _this.unitController.absoluteRange - _this.unitController.viewRangeLength);
                var end = start + _this.unitController.viewRangeLength;
                _this.unitController.viewRange = {
                    start: start,
                    end: end
                };
            }
        }, _this._displayObject);
        _this.addEvent('mouseup', _this._moveEndHandler, _this._displayObject);
        _this.addEvent('mouseupoutside', _this._moveEndHandler, _this._displayObject);
        return _this;
    }
    TimeGraphNavigatorHandle.prototype.render = function () {
        var MIN_NAVIGATOR_WIDTH = 20;
        var xPos = Number(this.unitController.viewRange.start) * this.stateController.absoluteResolution;
        var effectiveAbsoluteRange = Number(this.unitController.absoluteRange) * this.stateController.absoluteResolution;
        // Avoid the navigator rendered outside of the range at high zoom levels when its width is capped to MIN_NAVIGATOR_WIDTH
        var position = { x: Math.min(effectiveAbsoluteRange - MIN_NAVIGATOR_WIDTH, xPos), y: 0 };
        var width = Math.max(MIN_NAVIGATOR_WIDTH, Number(this.unitController.viewRangeLength) * this.stateController.absoluteResolution);
        this.rect({
            height: 20,
            position: position,
            width: width,
            color: 0x777769
        });
    };
    return TimeGraphNavigatorHandle;
}(time_graph_component_1.TimeGraphComponent));
exports.TimeGraphNavigatorHandle = TimeGraphNavigatorHandle;
var TimeGraphNavigatorBackground = /** @class */ (function (_super) {
    __extends(TimeGraphNavigatorBackground, _super);
    function TimeGraphNavigatorBackground(unitController, stateController) {
        var _this = _super.call(this, "navigator_background") || this;
        _this.unitController = unitController;
        _this.stateController = stateController;
        _this.toggleSnappedState = function (bool) {
            _this.stateController.snapped = bool;
        };
        _this.addEvent("mousedown", function (event) {
            var x = event.data.getLocalPosition(_this._displayObject).x;
            var middle = bigint_utils_1.BIMath.round((x / _this.stateController.canvasDisplayWidth) * Number(_this.unitController.absoluteRange));
            // We have horizontal offset at point of click, now we need coord for start of handler.
            var hVL = _this.unitController.viewRangeLength / BigInt(2);
            var start0 = middle - hVL;
            var max = _this.unitController.absoluteRange - _this.unitController.viewRangeLength;
            var min = BigInt(0);
            // Clamp it.
            var start = bigint_utils_1.BIMath.clamp(start0, min, max);
            _this.unitController.viewRange = {
                start: start,
                end: start + _this.unitController.viewRangeLength
            };
            // Set snapped state
            _this.toggleSnappedState(true);
        }, _this._displayObject);
        // Custom event lets handler know 'mouseup' triggers.
        _this.snapEvent = new CustomEvent(_this.snapEventString = 'snap-x-end');
        var endSnap = function () {
            _this.toggleSnappedState(false);
            document.dispatchEvent(_this.snapEvent);
        };
        _this.addEvent('mouseup', endSnap, _this._displayObject);
        _this.addEvent('mouseupoutside', endSnap, _this._displayObject);
        return _this;
    }
    TimeGraphNavigatorBackground.prototype.render = function () {
        this.rect({
            height: 20,
            position: {
                x: 0,
                y: 0
            },
            width: this.stateController.canvasDisplayWidth,
            opacity: 0
        });
    };
    return TimeGraphNavigatorBackground;
}(time_graph_component_1.TimeGraphComponent));
exports.TimeGraphNavigatorBackground = TimeGraphNavigatorBackground;
//# sourceMappingURL=time-graph-navigator.js.map