/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.plugin.internal.ResolveClasspathsHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ls.core.internal.BuildWorkspaceStatus;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;

public class Compile {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static final int GRADLE_BS_COMPILATION_ERROR = 100;

    public static Object compile(CompileParams params, IProgressMonitor monitor) {
        IProject mainProject;
        IProject iProject = mainProject = params == null ? null : ProjectUtils.getProject((String)params.getProjectName());
        if (mainProject == null) {
            try {
                List<IJavaProject> javaProjects = ResolveClasspathsHandler.getJavaProjectFromType(params.getMainClass());
                if (javaProjects.size() == 1) {
                    mainProject = javaProjects.get(0).getProject();
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException((String)"Failed to resolve project from main class name.", (Throwable)e);
            }
        }
        if (Compile.isBspProject(mainProject)) {
            try {
                ResourcesPlugin.getWorkspace().build(new IBuildConfiguration[]{mainProject.getActiveBuildConfig()}, 10, false, monitor);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 75) {
                    return 100;
                }
                return BuildWorkspaceStatus.FAILED;
            }
            return BuildWorkspaceStatus.SUCCEED;
        }
        try {
            IType mainType;
            if (monitor.isCanceled()) {
                return BuildWorkspaceStatus.CANCELLED;
            }
            long compileAt = System.currentTimeMillis();
            if (params != null && params.isFullBuild()) {
                ResourcesPlugin.getWorkspace().build(15, monitor);
                ResourcesPlugin.getWorkspace().build(6, monitor);
            } else {
                ResourcesPlugin.getWorkspace().build(10, monitor);
            }
            logger.info("Time cost for ECJ: " + (System.currentTimeMillis() - compileAt) + "ms");
            IProject currentResource = mainProject;
            if (Compile.isUnmanagedFolder(mainProject) && StringUtils.isNotBlank((CharSequence)params.getMainClass()) && (mainType = ProjectUtils.getJavaProject((IProject)mainProject).findType(params.getMainClass())) != null && mainType.getResource() != null) {
                currentResource = mainType.getResource();
            }
            ArrayList problemMarkers = new ArrayList();
            if (currentResource != null) {
                List markers = ResourceUtils.getErrorMarkers((IResource)currentResource);
                if (markers != null) {
                    problemMarkers.addAll(markers);
                }
                if (currentResource instanceof IProject && ProjectUtils.isJavaProject((IProject)currentResource)) {
                    IJavaProject[] javaProjects;
                    IJavaProject currentJavaProject = ProjectUtils.getJavaProject((IProject)currentResource);
                    IJavaProject[] iJavaProjectArray = javaProjects = ProjectUtils.getJavaProjects();
                    int n = javaProjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaProject otherJavaProject = iJavaProjectArray[n2];
                        IProject other = otherJavaProject.getProject();
                        if (!other.equals((Object)Compile.getDefaultProject()) && !other.equals((Object)currentResource) && currentJavaProject.isOnClasspath((IJavaElement)otherJavaProject) && (markers = ResourceUtils.getErrorMarkers((IResource)other)) != null) {
                            problemMarkers.addAll(markers);
                        }
                        ++n2;
                    }
                }
            } else {
                IJavaProject[] javaProjects;
                IJavaProject[] iJavaProjectArray = javaProjects = ProjectUtils.getJavaProjects();
                int n = javaProjects.length;
                int n3 = 0;
                while (n3 < n) {
                    List markers;
                    IJavaProject javaProject = iJavaProjectArray[n3];
                    IProject project = javaProject.getProject();
                    if (!project.equals((Object)Compile.getDefaultProject()) && (markers = ResourceUtils.getErrorMarkers((IResource)project)) != null) {
                        problemMarkers.addAll(markers);
                    }
                    ++n3;
                }
            }
            if (problemMarkers.isEmpty()) {
                return BuildWorkspaceStatus.SUCCEED;
            }
            return BuildWorkspaceStatus.WITH_ERROR;
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException((String)"Failed to build workspace.", (Throwable)e);
            return BuildWorkspaceStatus.FAILED;
        }
        catch (OperationCanceledException operationCanceledException) {
            return BuildWorkspaceStatus.CANCELLED;
        }
    }

    private static boolean isUnmanagedFolder(IProject project) {
        return project != null && ProjectUtils.isUnmanagedFolder((IProject)project) && ProjectUtils.isJavaProject((IProject)project);
    }

    private static boolean isBspProject(IProject project) {
        return project != null && ProjectUtils.isJavaProject((IProject)project) && ProjectUtils.hasNature((IProject)project, (String)"com.microsoft.gradle.bs.importer.GradleBuildServerProjectNature");
    }

    private static IProject getDefaultProject() {
        return Compile.getWorkspaceRoot().getProject("jdt.ls-java-project");
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    class CompileParams {
        String projectName;
        String mainClass;
        boolean isFullBuild = false;

        CompileParams() {
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public boolean isFullBuild() {
            return this.isFullBuild;
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

