"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NullPolicyService = exports.AbstractPolicyService = exports.IPolicyService = void 0;
const event_1 = require("../../../base/common/event");
const iterator_1 = require("../../../base/common/iterator");
const lifecycle_1 = require("../../../base/common/lifecycle");
const instantiation_1 = require("../../instantiation/common/instantiation");
exports.IPolicyService = (0, instantiation_1.createDecorator)('policy');
class AbstractPolicyService extends lifecycle_1.Disposable {
    constructor() {
        super(...arguments);
        this.policyDefinitions = {};
        this.policies = new Map();
        this._onDidChange = this._register(new event_1.Emitter());
        this.onDidChange = this._onDidChange.event;
    }
    registerPolicyDefinitions(policyDefinitions) {
        return __awaiter(this, void 0, void 0, function* () {
            const size = Object.keys(this.policyDefinitions).length;
            this.policyDefinitions = Object.assign(Object.assign({}, policyDefinitions), this.policyDefinitions);
            if (size !== Object.keys(this.policyDefinitions).length) {
                yield this.initializePolicies(policyDefinitions);
            }
            return iterator_1.Iterable.reduce(this.policies.entries(), (r, [name, value]) => (Object.assign(Object.assign({}, r), { [name]: value })), {});
        });
    }
    getPolicyValue(name) {
        return this.policies.get(name);
    }
    serialize() {
        return iterator_1.Iterable.reduce(Object.entries(this.policyDefinitions), (r, [name, definition]) => (Object.assign(Object.assign({}, r), { [name]: { definition, value: this.policies.get(name) } })), {});
    }
}
exports.AbstractPolicyService = AbstractPolicyService;
class NullPolicyService {
    constructor() {
        this.onDidChange = event_1.Event.None;
    }
    registerPolicyDefinitions() {
        return __awaiter(this, void 0, void 0, function* () { return {}; });
    }
    getPolicyValue() { return undefined; }
    serialize() { return undefined; }
}
exports.NullPolicyService = NullPolicyService;
//# sourceMappingURL=policy.js.map