"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
const editorExtensions_1 = require("../../../browser/editorExtensions");
const standaloneTheme_1 = require("../../common/standaloneTheme");
const standaloneStrings_1 = require("../../../common/standaloneStrings");
const theme_1 = require("../../../../platform/theme/common/theme");
const standaloneThemeService_1 = require("../standaloneThemeService");
class ToggleHighContrast extends editorExtensions_1.EditorAction {
    constructor() {
        super({
            id: 'editor.action.toggleHighContrast',
            label: standaloneStrings_1.ToggleHighContrastNLS.toggleHighContrast,
            alias: 'Toggle High Contrast Theme',
            precondition: undefined
        });
        this._originalThemeName = null;
    }
    run(accessor, editor) {
        const standaloneThemeService = accessor.get(standaloneTheme_1.IStandaloneThemeService);
        const currentTheme = standaloneThemeService.getColorTheme();
        if ((0, theme_1.isHighContrast)(currentTheme.type)) {
            // We must toggle back to the integrator's theme
            standaloneThemeService.setTheme(this._originalThemeName || ((0, theme_1.isDark)(currentTheme.type) ? standaloneThemeService_1.VS_DARK_THEME_NAME : standaloneThemeService_1.VS_LIGHT_THEME_NAME));
            this._originalThemeName = null;
        }
        else {
            standaloneThemeService.setTheme((0, theme_1.isDark)(currentTheme.type) ? standaloneThemeService_1.HC_BLACK_THEME_NAME : standaloneThemeService_1.HC_LIGHT_THEME_NAME);
            this._originalThemeName = currentTheme.themeName;
        }
    }
}
(0, editorExtensions_1.registerEditorAction)(ToggleHighContrast);
//# sourceMappingURL=toggleHighContrast.js.map