/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbolParams;

public class WorkspaceSymbolHandler {
    public static List<SymbolInformation> search(String query, IProgressMonitor monitor) {
        return WorkspaceSymbolHandler.search(query, 0, null, false, monitor);
    }

    public static List<SymbolInformation> search(String query, String projectName, boolean sourceOnly, IProgressMonitor monitor) {
        return WorkspaceSymbolHandler.search(query, 0, projectName, sourceOnly, monitor);
    }

    public static List<SymbolInformation> search(String query, final int maxResults, String projectName, final boolean sourceOnly, final IProgressMonitor monitor) {
        final ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
        if (StringUtils.isBlank((CharSequence)query)) {
            return symbols;
        }
        try {
            try {
                monitor.beginTask("Searching the types...", 100);
                IJavaSearchScope searchScope = WorkspaceSymbolHandler.createSearchScope(projectName, sourceOnly);
                int typeMatchRule = 128;
                if (query.contains("*") || query.contains("?")) {
                    typeMatchRule |= 2;
                }
                new SearchEngine().searchAllTypeNames(null, 2, query.trim().toCharArray(), typeMatchRule, 0, searchScope, new TypeNameMatchRequestor(){

                    public void acceptTypeNameMatch(TypeNameMatch match) {
                        try {
                            Location location = null;
                            try {
                                if (!sourceOnly && match.getType().isBinary()) {
                                    location = JDTUtils.toLocation((IClassFile)match.getType().getClassFile());
                                } else if (!match.getType().isBinary()) {
                                    location = JDTUtils.toLocation((IJavaElement)match.getType());
                                }
                            }
                            catch (Exception e) {
                                JavaLanguageServerPlugin.logException("Unable to determine location for " + match.getSimpleTypeName(), e);
                                return;
                            }
                            if (location != null && match.getSimpleTypeName() != null && !match.getSimpleTypeName().isEmpty()) {
                                SymbolInformation symbolInformation = new SymbolInformation();
                                symbolInformation.setContainerName(match.getTypeContainerName());
                                symbolInformation.setName(match.getSimpleTypeName());
                                symbolInformation.setKind(this.mapKind(match));
                                symbolInformation.setLocation(location);
                                symbols.add(symbolInformation);
                                if (maxResults > 0 && symbols.size() >= maxResults) {
                                    monitor.setCanceled(true);
                                }
                            }
                        }
                        catch (Exception e) {
                            JavaLanguageServerPlugin.logException("Unable to determine location for " + match.getSimpleTypeName(), e);
                            return;
                        }
                    }

                    private SymbolKind mapKind(TypeNameMatch match) {
                        int flags = match.getModifiers();
                        if (Flags.isInterface((int)flags)) {
                            return SymbolKind.Interface;
                        }
                        if (Flags.isAnnotation((int)flags)) {
                            return SymbolKind.Property;
                        }
                        if (Flags.isEnum((int)flags)) {
                            return SymbolKind.Enum;
                        }
                        return SymbolKind.Class;
                    }
                }, 3, monitor);
            }
            catch (Exception e) {
                if (!(e instanceof OperationCanceledException)) {
                    JavaLanguageServerPlugin.logException("Problem getting search for" + query, e);
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return symbols;
    }

    private static IJavaSearchScope createSearchScope(String projectName, boolean sourceOnly) throws JavaModelException {
        IJavaProject project = ProjectUtils.getJavaProject(projectName);
        IJavaProject[] targetProjects = project != null ? new IJavaProject[]{project} : ProjectUtils.getJavaProjects();
        int scope = 9;
        PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (!sourceOnly && preferenceManager != null && preferenceManager.isClientSupportsClassFileContent()) {
            scope |= 6;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])targetProjects, (int)scope);
    }

    public static class SearchSymbolParams
    extends WorkspaceSymbolParams {
        public String projectName;
        public boolean sourceOnly;
        public int maxResults;

        public SearchSymbolParams(String query, String projectName) {
            super(query);
            this.projectName = projectName;
        }
    }
}

