/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SelectionRangeParams;

public class SelectionRangeHandler {
    public List<SelectionRange> selectionRange(SelectionRangeParams params, IProgressMonitor monitor) {
        if (params.getPositions() == null || params.getPositions().isEmpty()) {
            return Collections.emptyList();
        }
        ITypeRoot root = JDTUtils.resolveTypeRoot(params.getTextDocument().getUri());
        if (root == null) {
            return Collections.emptyList();
        }
        CompilationUnit ast = CoreASTProvider.getInstance().getAST(root, CoreASTProvider.WAIT_YES, monitor);
        ArrayList<Comment> comments = new ArrayList<Comment>(ast.getCommentList());
        comments.removeIf(comment -> comment instanceof Javadoc);
        ArrayList<SelectionRange> $ = new ArrayList<SelectionRange>();
        for (Position pos : params.getPositions()) {
            try {
                int offset = JsonRpcHelpers.toOffset(root.getBuffer(), pos.getLine(), pos.getCharacter());
                ASTNode node = NodeFinder.perform((ASTNode)ast, (int)offset, (int)0);
                if (node == null) continue;
                ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
                while (node != null) {
                    nodes.add(node);
                    node = node.getParent();
                }
                SelectionRange selectionRange = null;
                ListIterator iterator = nodes.listIterator(nodes.size());
                while (iterator.hasPrevious()) {
                    node = (ASTNode)iterator.previous();
                    Range range = JDTUtils.toRange((IOpenable)root, node.getStartPosition(), node.getLength());
                    selectionRange = new SelectionRange(range, selectionRange);
                }
                ASTNode containingComment = this.containingComment(comments, offset);
                if (containingComment != null) {
                    Range range = JDTUtils.toRange((IOpenable)root, containingComment.getStartPosition(), containingComment.getLength());
                    selectionRange = new SelectionRange(range, selectionRange);
                }
                if (selectionRange == null) continue;
                $.add(selectionRange);
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException("Failed to calculate selection range", e);
            }
        }
        return $;
    }

    public ASTNode containingComment(List<Comment> comments, int offset) {
        for (Comment comment : comments) {
            ASTNode result = NodeFinder.perform((ASTNode)comment, (int)offset, (int)0);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

