/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.index.nexus;

import io.takari.aether.client.AetherClient;
import io.takari.aether.client.AetherClientAuthentication;
import io.takari.aether.client.AetherClientConfig;
import io.takari.aether.client.AetherClientProxy;
import io.takari.aether.client.Response;
import io.takari.aether.okhttp.OkHttpAetherClient;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.maven.index.updater.AbstractResourceFetcher;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherClientResourceFetcher
extends AbstractResourceFetcher {
    private AetherClient aetherClient;
    private final AuthenticationInfo authInfo;
    private final ProxyInfo proxyInfo;
    private final String userAgent;
    private final IProgressMonitor monitor;
    private String baseUrl;

    public AetherClientResourceFetcher(AuthenticationInfo authInfo, ProxyInfo proxyInfo, IProgressMonitor monitor) {
        this.authInfo = authInfo;
        this.proxyInfo = proxyInfo;
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
        this.userAgent = MavenPluginActivator.getUserAgent();
    }

    public void connect(String id, String url) {
        this.baseUrl = url;
        this.aetherClient = new OkHttpAetherClient((AetherClientConfig)new AetherClientConfigAdapter(this.baseUrl, this.authInfo, this.proxyInfo, this.userAgent, new HashMap<String, String>()));
    }

    public void disconnect() throws IOException {
        this.aetherClient.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public void retrieve(String name, File targetFile) throws IOException, FileNotFoundException {
        String url = String.valueOf(this.baseUrl) + "/" + name;
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Response response = this.aetherClient.get(url);
            try {
                block19: {
                    InputStream is = response.getInputStream();
                    try {
                        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile));){
                            byte[] buffer = new byte[0x100000];
                            int n = 0;
                            while (-1 != (n = is.read(buffer))) {
                                ((OutputStream)os).write(buffer, 0, n);
                                if (!this.monitor.isCanceled()) continue;
                                throw new OperationCanceledException();
                            }
                        }
                        if (is == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                }
                if (response == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (response == null) throw throwable;
                response.close();
                throw throwable;
            }
            response.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    class AetherClientConfigAdapter
    extends AetherClientConfig {
        private final Logger log = LoggerFactory.getLogger(AetherClientConfigAdapter.class);
        int connectionTimeout;
        int requestTimeout;
        AuthenticationInfo authInfo;
        ProxyInfo proxyInfo;
        String userAgent;
        String baseUrl;
        Map<String, String> headers;

        public AetherClientConfigAdapter(String baseUrl, AuthenticationInfo authInfo, ProxyInfo proxyInfo, String userAgent, Map<String, String> headers) {
            this.baseUrl = baseUrl;
            this.authInfo = authInfo;
            this.proxyInfo = proxyInfo;
            this.userAgent = userAgent;
            this.headers = headers;
            try {
                this.setSslSocketFactory(SSLContext.getDefault().getSocketFactory());
            }
            catch (NoSuchAlgorithmException ex) {
                this.log.warn(Messages.AetherClientConfigAdapter_error_sslContext);
            }
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public int getRequestTimeout() {
            return this.requestTimeout;
        }

        public AetherClientProxy getProxy() {
            if (this.proxyInfo == null) {
                return null;
            }
            try {
                if (ProxyUtils.validateNonProxyHosts((ProxyInfo)this.proxyInfo, (String)new URL(this.baseUrl).getHost())) {
                    return null;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return new AetherClientProxy(){

                public String getHost() {
                    return AetherClientConfigAdapter.this.proxyInfo.getHost();
                }

                public int getPort() {
                    return AetherClientConfigAdapter.this.proxyInfo.getPort();
                }

                public AetherClientAuthentication getAuthentication() {
                    if (AetherClientConfigAdapter.this.proxyInfo != null && AetherClientConfigAdapter.this.proxyInfo.getUserName() != null && AetherClientConfigAdapter.this.proxyInfo.getPassword() != null) {
                        return new AetherClientAuthentication(AetherClientConfigAdapter.this.proxyInfo.getUserName(), AetherClientConfigAdapter.this.proxyInfo.getPassword());
                    }
                    return null;
                }
            };
        }

        public AetherClientAuthentication getAuthentication() {
            if (this.authInfo != null) {
                return new AetherClientAuthentication(this.authInfo.getUserName(), this.authInfo.getPassword());
            }
            return null;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }
}

