/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { createDecorator } from '../../../platform/instantiation/common/instantiation';
import { URI } from '../../../base/common/uri';
import { isObject } from '../../../base/common/types';
export var IBulkEditService = createDecorator('IWorkspaceEditService');
function isWorkspaceFileEdit(thing) {
    return isObject(thing) && (Boolean(thing.newUri) || Boolean(thing.oldUri));
}
function isWorkspaceTextEdit(thing) {
    return isObject(thing) && URI.isUri(thing.resource) && isObject(thing.edit);
}
var ResourceEdit = /** @class */ (function () {
    function ResourceEdit(metadata) {
        this.metadata = metadata;
    }
    ResourceEdit.convert = function (edit) {
        return edit.edits.map(function (edit) {
            if (isWorkspaceTextEdit(edit)) {
                return new ResourceTextEdit(edit.resource, edit.edit, edit.modelVersionId, edit.metadata);
            }
            if (isWorkspaceFileEdit(edit)) {
                return new ResourceFileEdit(edit.oldUri, edit.newUri, edit.options, edit.metadata);
            }
            throw new Error('Unsupported edit');
        });
    };
    return ResourceEdit;
}());
export { ResourceEdit };
var ResourceTextEdit = /** @class */ (function (_super) {
    __extends(ResourceTextEdit, _super);
    function ResourceTextEdit(resource, textEdit, versionId, metadata) {
        var _this = _super.call(this, metadata) || this;
        _this.resource = resource;
        _this.textEdit = textEdit;
        _this.versionId = versionId;
        _this.metadata = metadata;
        return _this;
    }
    return ResourceTextEdit;
}(ResourceEdit));
export { ResourceTextEdit };
var ResourceFileEdit = /** @class */ (function (_super) {
    __extends(ResourceFileEdit, _super);
    function ResourceFileEdit(oldResource, newResource, options, metadata) {
        var _this = _super.call(this, metadata) || this;
        _this.oldResource = oldResource;
        _this.newResource = newResource;
        _this.options = options;
        _this.metadata = metadata;
        return _this;
    }
    return ResourceFileEdit;
}(ResourceEdit));
export { ResourceFileEdit };
