/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import './dropdown.css';
import { Action } from '../../../common/actions';
import { append, $ } from '../../dom';
import { Emitter } from '../../../common/event';
import { ActionViewItem, BaseActionViewItem } from '../actionbar/actionViewItems';
import { DropdownMenu } from './dropdown';
import { Codicon } from '../../../common/codicons';
var DropdownMenuActionViewItem = /** @class */ (function (_super) {
    __extends(DropdownMenuActionViewItem, _super);
    function DropdownMenuActionViewItem(action, menuActionsOrProvider, contextMenuProvider, options) {
        if (options === void 0) { options = {}; }
        var _this = _super.call(this, null, action, options) || this;
        _this.options = options;
        _this.actionItem = null;
        _this._onDidChangeVisibility = _this._register(new Emitter());
        _this.onDidChangeVisibility = _this._onDidChangeVisibility.event;
        _this.menuActionsOrProvider = menuActionsOrProvider;
        _this.contextMenuProvider = contextMenuProvider;
        if (_this.options.actionRunner) {
            _this.actionRunner = _this.options.actionRunner;
        }
        return _this;
    }
    DropdownMenuActionViewItem.prototype.render = function (container) {
        var _this = this;
        this.actionItem = container;
        var labelRenderer = function (el) {
            var _a;
            _this.element = append(el, $('a.action-label'));
            var classNames = [];
            if (typeof _this.options.classNames === 'string') {
                classNames = _this.options.classNames.split(/\s+/g).filter(function (s) { return !!s; });
            }
            else if (_this.options.classNames) {
                classNames = _this.options.classNames;
            }
            // todo@aeschli: remove codicon, should come through `this.options.classNames`
            if (!classNames.find(function (c) { return c === 'icon'; })) {
                classNames.push('codicon');
            }
            (_a = _this.element.classList).add.apply(_a, __spreadArray([], __read(classNames)));
            _this.element.setAttribute('role', 'button');
            _this.element.setAttribute('aria-haspopup', 'true');
            _this.element.setAttribute('aria-expanded', 'false');
            _this.element.title = _this._action.label || '';
            return null;
        };
        var isActionsArray = Array.isArray(this.menuActionsOrProvider);
        var options = {
            contextMenuProvider: this.contextMenuProvider,
            labelRenderer: labelRenderer,
            menuAsChild: this.options.menuAsChild,
            actions: isActionsArray ? this.menuActionsOrProvider : undefined,
            actionProvider: isActionsArray ? undefined : this.menuActionsOrProvider
        };
        this.dropdownMenu = this._register(new DropdownMenu(container, options));
        this._register(this.dropdownMenu.onDidChangeVisibility(function (visible) {
            var _a;
            (_a = _this.element) === null || _a === void 0 ? void 0 : _a.setAttribute('aria-expanded', "" + visible);
            _this._onDidChangeVisibility.fire(visible);
        }));
        this.dropdownMenu.menuOptions = {
            actionViewItemProvider: this.options.actionViewItemProvider,
            actionRunner: this.actionRunner,
            getKeyBinding: this.options.keybindingProvider,
            context: this._context
        };
        if (this.options.anchorAlignmentProvider) {
            var that_1 = this;
            this.dropdownMenu.menuOptions = __assign(__assign({}, this.dropdownMenu.menuOptions), { get anchorAlignment() {
                    return that_1.options.anchorAlignmentProvider();
                } });
        }
        this.updateEnabled();
    };
    DropdownMenuActionViewItem.prototype.setActionContext = function (newContext) {
        _super.prototype.setActionContext.call(this, newContext);
        if (this.dropdownMenu) {
            if (this.dropdownMenu.menuOptions) {
                this.dropdownMenu.menuOptions.context = newContext;
            }
            else {
                this.dropdownMenu.menuOptions = { context: newContext };
            }
        }
    };
    DropdownMenuActionViewItem.prototype.show = function () {
        if (this.dropdownMenu) {
            this.dropdownMenu.show();
        }
    };
    DropdownMenuActionViewItem.prototype.updateEnabled = function () {
        var _a, _b;
        var disabled = !this.getAction().enabled;
        (_a = this.actionItem) === null || _a === void 0 ? void 0 : _a.classList.toggle('disabled', disabled);
        (_b = this.element) === null || _b === void 0 ? void 0 : _b.classList.toggle('disabled', disabled);
    };
    return DropdownMenuActionViewItem;
}(BaseActionViewItem));
export { DropdownMenuActionViewItem };
var ActionWithDropdownActionViewItem = /** @class */ (function (_super) {
    __extends(ActionWithDropdownActionViewItem, _super);
    function ActionWithDropdownActionViewItem(context, action, options, contextMenuProvider) {
        var _this = _super.call(this, context, action, options) || this;
        _this.contextMenuProvider = contextMenuProvider;
        return _this;
    }
    ActionWithDropdownActionViewItem.prototype.render = function (container) {
        var _this = this;
        _super.prototype.render.call(this, container);
        if (this.element) {
            this.element.classList.add('action-dropdown-item');
            var menuActionsProvider = {
                getActions: function () {
                    var actionsProvider = _this.options.menuActionsOrProvider;
                    return __spreadArray([_this._action], __read((Array.isArray(actionsProvider)
                        ? actionsProvider
                        : actionsProvider.getActions()) // TODO: microsoft/TypeScript#42768
                    ));
                }
            };
            this.dropdownMenuActionViewItem = new DropdownMenuActionViewItem(this._register(new Action('dropdownAction', undefined)), menuActionsProvider, this.contextMenuProvider, { classNames: __spreadArray(__spreadArray(['dropdown'], __read(Codicon.dropDownButton.classNamesArray)), __read(this.options.menuActionClassNames || [])) });
            this.dropdownMenuActionViewItem.render(this.element);
        }
    };
    return ActionWithDropdownActionViewItem;
}(ActionViewItem));
export { ActionWithDropdownActionViewItem };
