/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.tests.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.tests.common.JobHelpers;
import org.junit.Assert;

public class WorkspaceHelpers {
    public static String getModelId(MavenProject mavenProject) {
        return mavenProject.getGroupId() + ":" + mavenProject.getArtifactId() + ":" + mavenProject.getVersion();
    }

    public static void cleanWorkspace() throws InterruptedException, CoreException {
        Exception cause = null;
        int i = 0;
        while (i < 10) {
            block4: {
                try {
                    System.gc();
                    WorkspaceHelpers.doCleanWorkspace();
                }
                catch (InterruptedException | OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    cause = e;
                    e.printStackTrace();
                    System.out.println(i);
                    Thread.sleep(6000L);
                    break block4;
                }
                return;
            }
            ++i;
        }
        throw new CoreException(Status.error((String)("Could not delete workspace resources (after " + i + " retries): " + String.valueOf(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()))), (Throwable)cause));
    }

    private static void doCleanWorkspace() throws InterruptedException, CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.run(monitor -> {
            IProject[] projects;
            IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                project.delete(true, true, monitor);
                ++n2;
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        JobHelpers.waitForJobsToComplete((IProgressMonitor)new NullProgressMonitor());
        File[] files = workspace.getRoot().getLocation().toFile().listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!".metadata".equals(file.getName())) {
                    if (file.isDirectory()) {
                        FileUtils.deleteDirectory((File)file);
                    } else {
                        Files.delete(file.toPath());
                    }
                }
                ++n2;
            }
        }
    }

    public static String toString(IMarker[] markers) {
        if (markers != null) {
            return WorkspaceHelpers.toString(Arrays.asList(markers));
        }
        return "";
    }

    public static String toString(List<IMarker> markers) {
        return markers.stream().map(WorkspaceHelpers::toString).collect(Collectors.joining(","));
    }

    protected static String toString(IMarker marker) {
        try {
            return "Type=" + marker.getType() + ":Message=" + String.valueOf(marker.getAttribute("message")) + ":LineNumber=" + String.valueOf(marker.getAttribute("lineNumber"));
        }
        catch (CoreException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static List<IMarker> findMarkers(IProject project, int targetSeverity) throws CoreException {
        return WorkspaceHelpers.findMarkers(project, targetSeverity, null);
    }

    public static List<IMarker> findMarkers(IProject project, int targetSeverity, String withAttribute) throws CoreException {
        TreeSet<IMarker> errors = new TreeSet<IMarker>(Comparator.comparingInt(o -> o.getAttribute("lineNumber", -1)).thenComparing(o -> o.getAttribute("message", "")));
        IMarker[] iMarkerArray = project.findMarkers(null, true, 2);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute;
            IMarker marker = iMarkerArray[n2];
            int severity = marker.getAttribute("severity", 0);
            if (!(targetSeverity >= 0 && severity != targetSeverity || withAttribute != null && (attribute = marker.getAttribute(withAttribute, null)) == null)) {
                errors.add(marker);
            }
            ++n2;
        }
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        result.addAll(errors);
        return result;
    }

    public static List<IMarker> findWarningMarkers(IProject project) throws CoreException {
        return WorkspaceHelpers.findMarkers(project, 1);
    }

    public static List<IMarker> findErrorMarkers(IProject project) throws CoreException {
        return WorkspaceHelpers.findMarkers(project, 2);
    }

    public static void assertNoErrors(IProject project) throws CoreException {
        List<IMarker> markers = WorkspaceHelpers.findErrorMarkers(project);
        Assert.assertEquals((String)("Unexpected error markers " + WorkspaceHelpers.toString(markers)), (long)0L, (long)markers.size());
    }

    public static void assertNoWarnings(IProject project) throws CoreException {
        List<IMarker> markers = WorkspaceHelpers.findWarningMarkers(project);
        Assert.assertEquals((String)("Unexpected warning markers " + WorkspaceHelpers.toString(markers)), (long)0L, (long)markers.size());
    }

    public static IMarker assertErrorMarker(String type, String message, Integer lineNumber, String resourceRelativePath, IProject project) throws Exception {
        return WorkspaceHelpers.assertMarker(type, 2, message, lineNumber, resourceRelativePath, project);
    }

    public static IMarker assertWarningMarker(String type, String message, Integer lineNumber, String resourceRelativePath, IProject project) throws Exception {
        return WorkspaceHelpers.assertMarker(type, 1, message, lineNumber, resourceRelativePath, project);
    }

    private static IMarker findMarker(String type, String message, Integer lineNumber, String resourceRelativePath, List<IMarker> markers) throws Exception {
        for (IMarker marker : markers) {
            if (type != null && !type.equals(marker.getType()) || message != null && !marker.getAttribute("message", "").startsWith(message) || lineNumber != null && !lineNumber.equals(marker.getAttribute("lineNumber"))) continue;
            if (type != null && type.startsWith("org.eclipse.m2e.core.maven2Problem")) {
                Assert.assertEquals((String)("Marker not persistent:" + WorkspaceHelpers.toString(marker)), (Object)false, (Object)marker.getAttribute("transient"));
            }
            if (resourceRelativePath == null) {
                resourceRelativePath = "";
            }
            Assert.assertEquals((String)("Marker not on the expected resource:" + WorkspaceHelpers.toString(marker)), (Object)resourceRelativePath, (Object)marker.getResource().getProjectRelativePath().toString());
            return marker;
        }
        return null;
    }

    public static IMarker assertErrorMarker(String type, String message, Integer lineNumber, IProject project) throws Exception {
        return WorkspaceHelpers.assertMarker(type, 2, message, lineNumber, "pom.xml", project);
    }

    public static IMarker assertWarningMarker(String type, String message, Integer lineNumber, IProject project) throws Exception {
        return WorkspaceHelpers.assertMarker(type, 1, message, lineNumber, "pom.xml", project);
    }

    public static IMarker assertMarker(String type, int severity, String message, Integer lineNumber, String resourceRelativePath, IProject project) throws Exception {
        List<IMarker> markers = WorkspaceHelpers.findMarkers(project, severity);
        IMarker marker = WorkspaceHelpers.findMarker(type, message, lineNumber, resourceRelativePath, markers);
        if (marker == null) {
            Assert.fail((String)("Expected marker not found. Found " + (markers.isEmpty() ? "no markers" : "markers :") + WorkspaceHelpers.toString(markers)));
        }
        Assert.assertTrue((String)("Marker type " + type + " is not a subtype of org.eclipse.core.resources.problemmarker"), (boolean)marker.isSubtypeOf("org.eclipse.core.resources.problemmarker"));
        return marker;
    }

    public static void assertLifecycleIdErrorMarkerAttributes(IProject project, String lifecycleId) throws CoreException {
        List<IMarker> errorMarkers = WorkspaceHelpers.findErrorMarkers(project);
        Assert.assertNotNull(errorMarkers);
        Assert.assertEquals((String)WorkspaceHelpers.toString(errorMarkers), (long)1L, (long)errorMarkers.size());
        WorkspaceHelpers.assertLifecycleIdErrorMarkerAttributes(errorMarkers.get(0), lifecycleId);
    }

    public static void assertConfiguratorErrorMarkerAttributes(IProject project, String configuratorId) throws CoreException {
        List<IMarker> errorMarkers = WorkspaceHelpers.findErrorMarkers(project);
        Assert.assertNotNull(errorMarkers);
        Assert.assertEquals((String)WorkspaceHelpers.toString(errorMarkers), (long)1L, (long)errorMarkers.size());
        WorkspaceHelpers.assertConfiguratorErrorMarkerAttributes(errorMarkers.get(0), configuratorId);
    }

    public static void assertLifecycleIdErrorMarkerAttributes(IMarker marker, String lifecycleId) {
        Assert.assertEquals((String)"Marker's editor hint", (Object)"unknown_lifecycle_id", (Object)marker.getAttribute("editor_hint", null));
        Assert.assertEquals((String)"Marker's lifecycle", (Object)lifecycleId, (Object)marker.getAttribute("lifecyclePhase", null));
    }

    public static void assertConfiguratorErrorMarkerAttributes(IMarker marker, String configuratorId) {
        Assert.assertEquals((String)"Marker's editor hint", (Object)"missing_configurator", (Object)marker.getAttribute("editor_hint", null));
        Assert.assertEquals((String)"Marker's ConfiguratorID", (Object)configuratorId, (Object)marker.getAttribute("configuratorId", null));
    }

    public static void assertErrorMarkerAttributes(IMarker marker, MojoExecutionKey mojoExecution) {
        Assert.assertEquals((Object)"not_covered_mojo_execution", (Object)marker.getAttribute("editor_hint", null));
        Assert.assertEquals((String)"Marker's groupID", (Object)mojoExecution.groupId(), (Object)marker.getAttribute("groupId", null));
        Assert.assertEquals((String)"Marker's artifactId", (Object)mojoExecution.artifactId(), (Object)marker.getAttribute("artifactId", null));
        Assert.assertEquals((String)"Marker's executionId", (Object)mojoExecution.executionId(), (Object)marker.getAttribute("executionId", null));
        Assert.assertEquals((String)"Marker's goal", (Object)mojoExecution.goal(), (Object)marker.getAttribute("goal", null));
        Assert.assertEquals((String)"Marker's version", (Object)mojoExecution.version(), (Object)marker.getAttribute("version", null));
        Assert.assertEquals((String)"Marker's lifecyclePhase", (Object)mojoExecution.lifecyclePhase(), (Object)marker.getAttribute("lifecyclePhase", null));
    }

    public static void assertMarkerLocation(SourceLocation markerLocation, IMarker marker) throws CoreException {
        Assert.assertEquals((String)"Wrong line number", (Object)markerLocation.getLineNumber(), (Object)marker.getAttribute("lineNumber"));
        Assert.assertEquals((String)"Wrong column start", (Object)markerLocation.getColumnStart(), (Object)marker.getAttribute("columnStart"));
        Assert.assertEquals((String)"Wrong column end", (Object)markerLocation.getColumnEnd(), (Object)marker.getAttribute("columnEnd"));
        markerLocation = markerLocation.getLinkedLocation();
        if (markerLocation == null) {
            return;
        }
        Assert.assertEquals((String)"Wrong cause resource path", (Object)markerLocation.getResourcePath(), (Object)marker.getAttribute("causeResourcePath"));
        Assert.assertEquals((String)"Wrong cause resource id", (Object)markerLocation.getResourceId(), (Object)marker.getAttribute("causeResourceId"));
        Assert.assertEquals((String)"Wrong cause line number", (Object)markerLocation.getLineNumber(), (Object)marker.getAttribute("causeLineNumber"));
        Assert.assertEquals((String)"Wrong cause column start", (Object)markerLocation.getColumnStart(), (Object)marker.getAttribute("causeColumnStart"));
        Assert.assertEquals((String)"Wrong cause column end", (Object)markerLocation.getColumnEnd(), (Object)marker.getAttribute("causeColumnEnd"));
    }
}

