/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.target.editor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffectFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.databinding.swt.WidgetSideEffects;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.pde.target.BNDInstructions;
import org.eclipse.m2e.pde.target.DependencyDepth;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.m2e.pde.target.MavenTargetLocation;
import org.eclipse.m2e.pde.target.MavenTargetRepository;
import org.eclipse.m2e.pde.target.MissingMetadataMode;
import org.eclipse.m2e.pde.target.TemplateFeatureModel;
import org.eclipse.m2e.pde.ui.target.editor.FeatureSpecPage;
import org.eclipse.m2e.pde.ui.target.editor.MavenArtifactInstructionsWizard;
import org.eclipse.m2e.pde.ui.target.editor.MavenTargetDependencyEditor;
import org.eclipse.m2e.pde.ui.target.editor.MavenTargetRepositoryEditor;
import org.eclipse.m2e.pde.ui.target.editor.Messages;
import org.eclipse.m2e.pde.ui.target.editor.PluginListPage;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.ui.target.ITargetLocationWizard;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MavenTargetLocationWizard
extends Wizard
implements ITargetLocationWizard {
    private static final List<String> MAVEN_SCOPES = List.of("compile", "provided", "runtime", "test", "system", "import");
    private MavenTargetLocation targetLocation;
    private Button[] scopes;
    private ComboViewer metadata;
    private ComboViewer include;
    private ITargetDefinition targetDefinition;
    private BNDInstructions bndInstructions;
    private Button includeSource;
    private MavenTargetDependencyEditor dependencyEditor;
    private List<MavenTargetRepository> repositoryList = new ArrayList<MavenTargetRepository>();
    private Button createFeature;
    private WizardPage page;
    private FeatureSpecPage featureSpecPage;
    private PluginListPage pluginListPage;
    private Text locationLabel;
    private MavenTargetDependency selectedRoot;
    private static final GridDataFactory REPO_LINK_GRID_DATA = GridDataFactory.swtDefaults().span(2, 1);

    public MavenTargetLocationWizard() {
        this(null);
    }

    public MavenTargetLocationWizard(final MavenTargetLocation targetLocation) {
        this.targetLocation = targetLocation;
        this.setWindowTitle(Messages.MavenTargetLocationWizard_0);
        if (targetLocation != null) {
            for (MavenTargetRepository mavenTargetRepository : targetLocation.getExtraRepositories()) {
                this.repositoryList.add(mavenTargetRepository.copy());
            }
        }
        this.page = new WizardPage(targetLocation == null ? Messages.MavenTargetLocationWizard_1 : Messages.MavenTargetLocationWizard_2){
            private Link editInstructionsButton;
            private Label scopeLabel;

            public void createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                this.setControl((Control)composite);
                composite.setLayout((Layout)new GridLayout(2, false));
                MavenTargetLocationWizard.this.createRepositoryLink(composite);
                MavenTargetLocationWizard.this.dependencyEditor = new MavenTargetDependencyEditor(composite, targetLocation, MavenTargetLocationWizard.this.selectedRoot);
                MavenTargetLocationWizard.this.dependencyEditor.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_14);
                MavenTargetLocationWizard.this.locationLabel = new Text(composite, 2048);
                ModifyListener modifyListener = e -> {
                    String text = MavenTargetLocationWizard.this.locationLabel.getText();
                    if (text.isBlank()) {
                        MavenTargetLocationWizard.this.setWindowTitle(Messages.MavenTargetLocationWizard_0);
                    } else {
                        MavenTargetLocationWizard.this.setWindowTitle(Messages.MavenTargetLocationWizard_0 + " - " + text);
                    }
                };
                MavenTargetLocationWizard.this.locationLabel.addModifyListener(modifyListener);
                GridDataFactory.swtDefaults().align(4, 1).applyTo((Control)MavenTargetLocationWizard.this.locationLabel);
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_9);
                this.createMetadataCombo(composite);
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_17);
                this.createIncludeCombo(composite);
                this.scopeLabel = new Label(composite, 0);
                this.scopeLabel.setText(Messages.MavenTargetLocationWizard_10);
                this.createScopes(composite);
                MavenTargetLocationWizard.this.includeSource = this.createCheckBox(composite, Messages.MavenTargetLocationWizard_8);
                MavenTargetLocationWizard.this.createFeature = this.createCheckBox(composite, Messages.MavenTargetLocationWizard_13);
                MavenTargetLocationWizard.this.createFeature.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateUI()));
                if (targetLocation != null) {
                    Collection dependencyScopes = targetLocation.getDependencyScopes();
                    int i = 0;
                    while (i < MavenTargetLocationWizard.this.scopes.length) {
                        if (dependencyScopes.contains(MAVEN_SCOPES.get(i))) {
                            MavenTargetLocationWizard.this.scopes[i].setSelection(true);
                        }
                        ++i;
                    }
                    MavenTargetLocationWizard.this.metadata.setSelection((ISelection)new StructuredSelection((Object)targetLocation.getMetadataMode()));
                    MavenTargetLocationWizard.this.include.setSelection((ISelection)new StructuredSelection((Object)targetLocation.getDependencyDepth()));
                    MavenTargetLocationWizard.this.bndInstructions = targetLocation.getInstructions(null);
                    MavenTargetLocationWizard.this.includeSource.setSelection(targetLocation.isIncludeSource());
                    IFeature template = targetLocation.getFeatureTemplate();
                    MavenTargetLocationWizard.this.createFeature.setSelection(template != null);
                    MavenTargetLocationWizard.this.locationLabel.setText(Objects.requireNonNullElse(targetLocation.getLabel(), ""));
                    modifyListener.modifyText(null);
                } else {
                    MavenTargetLocationWizard.this.metadata.setSelection((ISelection)new StructuredSelection((Object)MavenTargetLocation.DEFAULT_METADATA_MODE));
                    MavenTargetLocationWizard.this.include.setSelection((ISelection)new StructuredSelection((Object)MavenTargetLocation.DEFAULT_INCLUDE_MODE));
                    MavenTargetLocationWizard.this.bndInstructions = BNDInstructions.EMPTY;
                    MavenTargetLocationWizard.this.includeSource.setSelection(true);
                }
                ISideEffectFactory factory = WidgetSideEffects.createFactory((Widget)composite);
                factory.create(() -> {
                    this.setErrorMessage(MavenTargetLocationWizard.this.dependencyEditor.hasErrors() ? Messages.MavenTargetDependencyEditor_15 : null);
                    this.setPageComplete(!MavenTargetLocationWizard.this.dependencyEditor.hasErrors());
                    this.updateUI();
                });
            }

            private Button createCheckBox(Composite composite, String text) {
                new Label(composite, 0);
                Button box = new Button(composite, 32);
                box.setText(text);
                return box;
            }

            private void createIncludeCombo(Composite parent) {
                Composite composite = new Composite(parent, 0);
                this.applyGridLayout(composite, 2, 20);
                MavenTargetLocationWizard.this.include = new ComboViewer(this.combo(new CCombo(composite, 0x800808)));
                Label includeLabel = new Label(composite, 0);
                includeLabel.setText(Messages.MavenTargetLocationWizard_16);
                MavenTargetLocationWizard.this.include.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                MavenTargetLocationWizard.this.include.setLabelProvider((IBaseLabelProvider)ColumnLabelProvider.createTextProvider(element -> {
                    if (element instanceof DependencyDepth) {
                        DependencyDepth depth = (DependencyDepth)element;
                        return depth.name().toLowerCase();
                    }
                    return element == null ? "" : element.toString();
                }));
                MavenTargetLocationWizard.this.include.setInput((Object)DependencyDepth.values());
                MavenTargetLocationWizard.this.include.addSelectionChangedListener(e -> this.updateUI());
            }

            private void createScopes(Composite parent) {
                Composite composite = new Composite(parent, 0);
                this.applyGridLayout(composite, MAVEN_SCOPES.size() + 1, 10);
                MavenTargetLocationWizard.this.scopes = new Button[MAVEN_SCOPES.size()];
                int i = 0;
                while (i < MavenTargetLocationWizard.this.scopes.length) {
                    MavenTargetLocationWizard.this.scopes[i] = new Button(composite, 32);
                    MavenTargetLocationWizard.this.scopes[i].setText(MAVEN_SCOPES.get(i));
                    MavenTargetLocationWizard.this.scopes[i].addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateUI()));
                    ++i;
                }
            }

            private void createMetadataCombo(Composite parent) {
                Composite composite = new Composite(parent, 0);
                this.applyGridLayout(composite, 2, 20);
                MavenTargetLocationWizard.this.metadata = new ComboViewer(this.combo(new CCombo(composite, 0x800808)));
                MavenTargetLocationWizard.this.metadata.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                MavenTargetLocationWizard.this.metadata.setLabelProvider((IBaseLabelProvider)ColumnLabelProvider.createTextProvider(element -> {
                    if (element instanceof MissingMetadataMode) {
                        MissingMetadataMode missingMode = (MissingMetadataMode)element;
                        return missingMode.name().toLowerCase();
                    }
                    return element == null ? "" : element.toString();
                }));
                this.editInstructionsButton = new Link(composite, 8);
                this.editInstructionsButton.setText(Messages.MavenTargetLocationWizard_20);
                this.editInstructionsButton.setToolTipText(Messages.MavenTargetLocationWizard_21);
                this.editInstructionsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                    BNDInstructions edited = MavenArtifactInstructionsWizard.openWizard(this.getShell(), Objects.requireNonNullElse(MavenTargetLocationWizard.this.bndInstructions, BNDInstructions.EMPTY));
                    if (edited != null) {
                        MavenTargetLocationWizard.this.bndInstructions = edited;
                    }
                }));
                MavenTargetLocationWizard.this.metadata.setInput((Object)MissingMetadataMode.values());
                MavenTargetLocationWizard.this.metadata.addSelectionChangedListener(e -> this.updateUI());
            }

            private void applyGridLayout(Composite composite, int numColumns, int horizontalSpacing) {
                GridLayout layout = new GridLayout(numColumns, false);
                layout.horizontalSpacing = horizontalSpacing;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                composite.setLayout((Layout)layout);
            }

            private void updateUI() {
                this.editInstructionsButton.setVisible(MavenTargetLocationWizard.this.metadata.getStructuredSelection().getFirstElement() == MissingMetadataMode.GENERATE);
                if (MavenTargetLocationWizard.this.include.getStructuredSelection().getFirstElement() == DependencyDepth.NONE) {
                    Button[] buttonArray = MavenTargetLocationWizard.this.scopes;
                    int n = MavenTargetLocationWizard.this.scopes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Button button = buttonArray[n2];
                        button.setEnabled(false);
                        ++n2;
                    }
                    this.scopeLabel.setEnabled(false);
                } else {
                    this.scopeLabel.setEnabled(true);
                    Button[] buttonArray = MavenTargetLocationWizard.this.scopes;
                    int n = MavenTargetLocationWizard.this.scopes.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Button button = buttonArray[n3];
                        button.setEnabled(true);
                        ++n3;
                    }
                }
                this.getContainer().updateButtons();
            }

            private CCombo combo(CCombo combo) {
                GridData data = new GridData();
                data.widthHint = 120;
                combo.setLayoutData((Object)data);
                return combo;
            }
        };
        this.page.setImageDescriptor(ImageDescriptor.createFromURL((URL)MavenTargetLocationWizard.class.getResource("/icons/new_m2_project_wizard.gif")));
        this.page.setTitle(this.page.getName());
        this.page.setDescription(Messages.MavenTargetLocationWizard_23);
        this.addPage((IWizardPage)this.page);
        this.featureSpecPage = new FeatureSpecPage(targetLocation);
        this.addPage((IWizardPage)this.featureSpecPage);
        this.pluginListPage = new PluginListPage(targetLocation);
        this.addPage((IWizardPage)this.pluginListPage);
    }

    public boolean canFinish() {
        if (this.isCreateFeature()) {
            return super.canFinish();
        }
        return this.page.isPageComplete();
    }

    private boolean isCreateFeature() {
        return this.createFeature != null && this.createFeature.getSelection();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.isCreateFeature()) {
            return super.getNextPage(page);
        }
        return null;
    }

    public void setTarget(ITargetDefinition target) {
        this.targetDefinition = target;
    }

    public ITargetLocation[] getLocations() {
        return new ITargetLocation[]{this.targetLocation};
    }

    public boolean performFinish() {
        List<BNDInstructions> list;
        Collection<Object> excludes;
        boolean iscreate = this.targetLocation == null;
        boolean createFeature = this.createFeature.getSelection();
        TemplateFeatureModel featureModel = null;
        if (iscreate) {
            excludes = Collections.emptyList();
            list = this.bndInstructions == null ? List.of() : List.of(this.bndInstructions);
        } else {
            IFeature featureTemplate;
            excludes = this.targetLocation.getExcludes();
            list = new ArrayList();
            for (BNDInstructions instruction : this.targetLocation.getInstructions()) {
                if (instruction.key().isBlank()) continue;
                list.add(instruction);
            }
            if (this.bndInstructions != null) {
                list.add(this.bndInstructions);
            }
            if ((featureTemplate = this.targetLocation.getFeatureTemplate()) != null) {
                try {
                    featureModel = new TemplateFeatureModel(featureTemplate);
                    featureModel.load();
                }
                catch (CoreException e) {
                    Platform.getLog(MavenTargetLocationWizard.class).log(e.getStatus());
                }
            }
        }
        if (createFeature) {
            if (featureModel == null) {
                featureModel = new TemplateFeatureModel(null);
            }
            try {
                this.featureSpecPage.update((IFeatureModel)featureModel, iscreate || this.targetLocation.getFeatureTemplate() == null);
                this.pluginListPage.update((IFeatureModel)featureModel);
            }
            catch (CoreException e) {
                Platform.getLog(MavenTargetLocationWizard.class).log(e.getStatus());
            }
            featureModel.makeReadOnly();
        }
        IFeature f = createFeature ? featureModel.getFeature() : null;
        LinkedHashSet<String> selectedScopes = new LinkedHashSet<String>();
        int i = 0;
        while (i < this.scopes.length) {
            if (this.scopes[i].getSelection()) {
                selectedScopes.add(MAVEN_SCOPES.get(i));
            }
            ++i;
        }
        DependencyDepth depth = (DependencyDepth)this.include.getStructuredSelection().getFirstElement();
        MavenTargetLocation location = new MavenTargetLocation(this.locationLabel.getText(), this.dependencyEditor.getRoots(), this.repositoryList, (MissingMetadataMode)this.metadata.getStructuredSelection().getFirstElement(), depth, selectedScopes, this.includeSource.getSelection(), list, excludes, f);
        if (iscreate) {
            this.targetLocation = location;
        } else {
            ITargetLocation[] locations = (ITargetLocation[])this.targetDefinition.getTargetLocations().clone();
            int i2 = 0;
            while (i2 < locations.length) {
                if (locations[i2] == this.targetLocation) {
                    locations[i2] = location;
                    break;
                }
                ++i2;
            }
            this.targetDefinition.setTargetLocations(locations);
        }
        return true;
    }

    private void createRepositoryLink(Composite composite) {
        Link link = new Link(composite, 0);
        link.setText(Messages.MavenTargetLocationWizard_12);
        REPO_LINK_GRID_DATA.applyTo((Control)link);
        link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if ("#maven".equals(e.text)) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)composite.getShell(), (String)"org.eclipse.m2e.core.preferences.MavenSettingsPreferencePage", (String[])new String[]{"org.eclipse.m2e.core.preferences.MavenSettingsPreferencePage", "org.eclipse.m2e.core.preferences.MavenInstallationsPreferencePage", "org.eclipse.m2e.core.preferences.MavenArchetypesPreferencePage", "org.eclipse.m2e.core.ui.preferences.UserInterfacePreferencePage", "org.eclipse.m2e.core.ui.preferences.WarningsPreferencePage", "org.eclipse.m2e.core.preferences.LifecycleMappingPreferencePag"}, null);
                dialog.open();
            } else if ("#configure".equals(e.text)) {
                MavenTargetRepositoryEditor editor = new MavenTargetRepositoryEditor(composite.getShell(), this.repositoryList);
                editor.open();
            }
        }));
    }

    public void setSelectedRoot(MavenTargetDependency selectedRoot) {
        this.selectedRoot = selectedRoot;
    }
}

