/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.TaskList;

public abstract class TaskListOperation {
    private final ISchedulingRule rule;
    private final TaskList taskList;

    public TaskListOperation(TaskList taskList) {
        this(null, taskList);
    }

    public TaskListOperation(ISchedulingRule rule, TaskList taskList) {
        this.rule = rule;
        this.taskList = taskList;
    }

    protected abstract void operations(IProgressMonitor var1) throws CoreException, InvocationTargetException, InterruptedException;

    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        InvocationTargetException[] ite = new InvocationTargetException[1];
        try {
            ITaskListRunnable runnable = monitor1 -> {
                try {
                    try {
                        Job.getJobManager().beginRule(this.rule, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor1, (int)-1));
                        this.operations(monitor1);
                    }
                    catch (InvocationTargetException e) {
                        invocationTargetExceptionArray[0] = e;
                        Job.getJobManager().endRule(this.rule);
                    }
                    catch (InterruptedException e) {
                        throw new OperationCanceledException(e.getMessage());
                    }
                }
                finally {
                    Job.getJobManager().endRule(this.rule);
                }
            };
            this.getTaskList().run(runnable, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        if (ite[0] != null) {
            throw ite[0];
        }
    }

    protected TaskList getTaskList() {
        return this.taskList;
    }
}

