/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.widgets;

import java.text.ParseException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.ui.dialogs.OpenAuditDialog;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.ValidationContext;
import org.eclipse.net4j.util.ui.ValidationParticipant;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectTimeStampComposite
extends Composite
implements ValidationParticipant {
    private ValidationContext validationContext;
    private CDOBranch branch;
    private long timeStamp;
    private Composite pointGroup;
    private Button headRadio;
    private Button baseRadio;
    private Text baseText;
    private Button timeRadio;
    private Text timeText;
    private Button timeBrowseButton;

    public SelectTimeStampComposite(Composite parent, int style) {
        this(parent, style, null, 0L);
    }

    public SelectTimeStampComposite(Composite parent, int style, CDOBranch branch, long timeStamp) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.pointGroup = new Composite((Composite)this, 0);
        this.pointGroup.setLayout((Layout)layout);
        this.baseRadio = new Button(this.pointGroup, 16);
        this.baseRadio.setText(Messages.getString("BranchSelectionDialog.2"));
        this.baseRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectTimeStampComposite.this.baseRadio.getSelection()) {
                    SelectTimeStampComposite.this.setTimeStamp(SelectTimeStampComposite.this.branch.getBase().getTimeStamp());
                }
            }
        });
        this.baseText = new Text(this.pointGroup, 2048);
        this.baseText.setLayoutData((Object)this.createTimeGridData());
        this.baseText.setEnabled(false);
        new Label(this.pointGroup, 0);
        this.timeRadio = new Button(this.pointGroup, 16);
        this.timeRadio.setText(Messages.getString("BranchSelectionDialog.3"));
        this.timeRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectTimeStampComposite.this.timeRadio.getSelection()) {
                    SelectTimeStampComposite.this.parseTime();
                }
            }
        });
        this.timeText = new Text(this.pointGroup, 2048);
        this.timeText.setLayoutData((Object)this.createTimeGridData());
        this.timeText.setText(CDOCommonUtil.formatTimeStamp((long)(timeStamp > 0L ? timeStamp : System.currentTimeMillis())));
        this.timeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectTimeStampComposite.this.parseTime();
            }
        });
        this.timeText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SelectTimeStampComposite.this.selectRadio(SelectTimeStampComposite.this.timeRadio);
            }
        });
        this.timeBrowseButton = new Button(this.pointGroup, 0);
        this.timeBrowseButton.setImage(SharedIcons.getImage((String)"etool16/clock.png"));
        this.timeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectTimeStampComposite.this.selectRadio(SelectTimeStampComposite.this.timeRadio);
                OpenAuditDialog dialog = new OpenAuditDialog(UIUtil.getActiveWorkbenchPage());
                if (dialog.open() == 0) {
                    SelectTimeStampComposite.this.setTimeStamp(dialog.getTimeStamp());
                }
            }
        });
        this.headRadio = new Button(this.pointGroup, 16);
        this.headRadio.setText(Messages.getString("BranchSelectionDialog.1"));
        this.headRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectTimeStampComposite.this.headRadio.getSelection()) {
                    SelectTimeStampComposite.this.setTimeStamp(0L);
                }
            }
        });
        new Label(this.pointGroup, 0);
        new Label(this.pointGroup, 0);
        this.timeStamp = timeStamp;
        this.setBranch(branch);
    }

    public ValidationContext getValidationContext() {
        return this.validationContext;
    }

    public void setValidationContext(ValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    public CDOBranch getBranch() {
        return this.branch;
    }

    public void setBranch(CDOBranch branch) {
        this.branch = branch;
        this.headRadio.setEnabled(branch != null);
        this.baseRadio.setEnabled(branch != null);
        this.baseText.setText(branch != null ? CDOCommonUtil.formatTimeStamp((long)branch.getBase().getTimeStamp()) : "");
        this.setTimeStamp(this.timeStamp);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        long oldTimeStamp = this.timeStamp;
        this.timeStamp = timeStamp;
        if (this.branch != null && (timeStamp == -1L || timeStamp == 0L)) {
            this.selectRadio(this.headRadio);
        } else if (this.branch != null && timeStamp == this.branch.getBase().getTimeStamp()) {
            this.selectRadio(this.baseRadio);
        } else {
            this.selectRadio(this.timeRadio);
        }
        if (oldTimeStamp != timeStamp) {
            this.timeStampChanged(timeStamp);
        }
    }

    protected void timeStampChanged(long timeStamp) {
    }

    public Button getHeadRadio() {
        return this.headRadio;
    }

    public Button getBaseRadio() {
        return this.baseRadio;
    }

    public Text getBaseText() {
        return this.baseText;
    }

    public Button getTimeRadio() {
        return this.timeRadio;
    }

    public Text getTimeText() {
        return this.timeText;
    }

    public Button getTimeBrowseButton() {
        return this.timeBrowseButton;
    }

    private GridData createTimeGridData() {
        GridData gd2 = UIUtil.createGridData((boolean)false, (boolean)false);
        gd2.widthHint = 160;
        return gd2;
    }

    private void parseTime() {
        block6: {
            try {
                String text = this.timeText.getText();
                if (StringUtil.isEmpty((String)text)) {
                    if (this.validationContext != null) {
                        this.validationContext.setValidationError((Object)this.timeText, "Please enter a valid time stamp.");
                    }
                    return;
                }
                long timeStamp = CDOCommonUtil.parseTimeStamp((String)text);
                this.setTimeStamp(timeStamp);
                if (this.validationContext != null) {
                    long repositoryCreation;
                    String message = null;
                    if (this.branch != null && timeStamp != 0L && timeStamp != -1L && timeStamp < (repositoryCreation = this.branch.getBranchManager().getMainBranch().getBase().getTimeStamp())) {
                        message = "The repository did not exist before " + CDOCommonUtil.formatTimeStamp((long)repositoryCreation) + ".";
                    }
                    this.validationContext.setValidationError((Object)this.timeText, message);
                }
            }
            catch (ParseException ex) {
                if (this.validationContext == null) break block6;
                this.validationContext.setValidationError((Object)this.timeText, "Invalid time stamp.");
            }
        }
    }

    private void selectRadio(Button button) {
        this.headRadio.setSelection(button == this.headRadio);
        this.baseRadio.setSelection(button == this.baseRadio);
        this.timeRadio.setSelection(button == this.timeRadio);
    }
}

