/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.annotations;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.pde.core.IBaseModel;

public interface OSGiAnnotationProcessor {
    public void processAnnotation(Annotation var1, String var2);

    public void apply(IBaseModel var1);

    public static Optional<String> stringValue(Expression expression) {
        return Optional.ofNullable(expression).filter(StringLiteral.class::isInstance).map(StringLiteral.class::cast).map(StringLiteral::getLiteralValue);
    }

    public static Stream<Expression> expressions(Expression expression) {
        Expression unwrap = OSGiAnnotationProcessor.value(expression).orElse(expression);
        if (unwrap instanceof ArrayInitializer) {
            ArrayInitializer arrayInitializer = (ArrayInitializer)unwrap;
            return arrayInitializer.expressions().stream().filter(Expression.class::isInstance).map(Expression.class::cast);
        }
        return Stream.of(expression);
    }

    public static Optional<Expression> value(Expression annotation) {
        return OSGiAnnotationProcessor.member(annotation, "value");
    }

    public static Optional<Expression> member(Expression annotation, String memberName) {
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            for (Object value : normalAnnotation.values()) {
                MemberValuePair pair;
                SimpleName name;
                if (!(value instanceof MemberValuePair) || (name = (pair = (MemberValuePair)value).getName()) == null || !name.toString().equals(memberName)) continue;
                return Optional.ofNullable(pair.getValue());
            }
        }
        if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            if ("value".equals(memberName)) {
                return Optional.ofNullable(singleMemberAnnotation.getValue());
            }
        }
        return Optional.empty();
    }
}

