/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.ui;

import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;

public class PerspectiveChangeMonitor
extends PerspectiveAdapter {
    public static final String PERSPECTIVE_SAVED = "perspective saved";
    public static final String PERSPECTIVE_OPENED = "perspective opened";
    public static final String PERSPECTIVE_CLOSED = "perspective closed";
    public static final String PERSPECTIVE_CHANGED = "perspective changed";
    public static final String PERSPECTIVE_ACTIVATED = "perspective activated";

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        String source = this.getPerspectiveId(perspective);
        InteractionEvent interactionEvent = InteractionEvent.makePreference((String)source, (String)PERSPECTIVE_ACTIVATED);
        MonitorUiPlugin.getDefault().notifyInteractionObserved(interactionEvent);
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        if (partRef != null) {
            String source = partRef.getId();
            InteractionEvent interactionEvent = InteractionEvent.makePreference((String)source, (String)("perspective changed: " + changeId));
            MonitorUiPlugin.getDefault().notifyInteractionObserved(interactionEvent);
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        String source = this.getPerspectiveId(perspective);
        InteractionEvent interactionEvent = InteractionEvent.makePreference((String)source, (String)("perspective changed: " + changeId));
        MonitorUiPlugin.getDefault().notifyInteractionObserved(interactionEvent);
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        String source = this.getPerspectiveId(perspective);
        InteractionEvent interactionEvent = InteractionEvent.makePreference((String)source, (String)PERSPECTIVE_CLOSED);
        MonitorUiPlugin.getDefault().notifyInteractionObserved(interactionEvent);
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        String source = this.getPerspectiveId(perspective);
        InteractionEvent interactionEvent = InteractionEvent.makePreference((String)source, (String)PERSPECTIVE_OPENED);
        MonitorUiPlugin.getDefault().notifyInteractionObserved(interactionEvent);
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
        String source = this.getPerspectiveId(newPerspective);
        InteractionEvent interactionEvent = InteractionEvent.makePreference((String)source, (String)PERSPECTIVE_SAVED);
        MonitorUiPlugin.getDefault().notifyInteractionObserved(interactionEvent);
    }

    private String getPerspectiveId(IPerspectiveDescriptor perspective) {
        String originalId;
        Object id = perspective instanceof PerspectiveDescriptor ? (!(originalId = ((PerspectiveDescriptor)perspective).getOriginalId()).equals(perspective.getId()) ? originalId + "[customized]" : perspective.getId()) : perspective.getId();
        return id;
    }
}

