/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark;

import java.util.HashSet;
import java.util.Set;

public class IgnoredHtmlElement {
    private String tagName;
    private Set<String> attributes;

    public IgnoredHtmlElement(String tagName) {
        this.tagName = tagName;
        this.attributes = new HashSet<String>();
    }

    public static IgnoredHtmlElement create(String tagName, String ... attributes) {
        IgnoredHtmlElement el = new IgnoredHtmlElement(tagName);
        for (String attr : attributes) {
            el.addAttribute(attr);
        }
        return el;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Set<String> getAttributes() {
        return this.attributes;
    }

    public boolean addAttribute(String attributeName) {
        return this.attributes.add(attributeName);
    }

    public void addAttributes(String ... attributes) {
        for (String attr : attributes) {
            this.addAttribute(attr);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgnoredHtmlElement that = (IgnoredHtmlElement)o;
        return this.tagName.equals(that.tagName);
    }

    public int hashCode() {
        return this.tagName.hashCode();
    }
}

