/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.descriptor.DynamicDescendantFilter;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

abstract class TemplateExecutor<P extends Extension, C> {
    private final TestDescriptor parent;
    private final Class<P> providerType;
    private final DynamicDescendantFilter dynamicDescendantFilter;

    <T extends TestDescriptor & Filterable> TemplateExecutor(T parent, Class<P> providerType) {
        this.parent = parent;
        this.providerType = providerType;
        this.dynamicDescendantFilter = ((Filterable)parent).getDynamicDescendantFilter();
    }

    void execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
        ExtensionContext extensionContext = context.getExtensionContext();
        List<P> providers = this.validateProviders(extensionContext, context.getExtensionRegistry());
        AtomicInteger invocationIndex = new AtomicInteger();
        for (Extension provider : providers) {
            this.executeForProvider(provider, invocationIndex, dynamicTestExecutor, extensionContext);
        }
    }

    private void executeForProvider(P provider, AtomicInteger invocationIndex, Node.DynamicTestExecutor dynamicTestExecutor, ExtensionContext extensionContext) {
        int initialValue = invocationIndex.get();
        try (Stream<C> stream = this.provideContexts(provider, extensionContext);){
            stream.forEach(invocationContext -> this.createInvocationTestDescriptor(invocationContext, invocationIndex.incrementAndGet()).ifPresent(testDescriptor -> this.execute(dynamicTestExecutor, (TestDescriptor)testDescriptor)));
        }
        Preconditions.condition((invocationIndex.get() != initialValue || this.mayReturnZeroContexts(provider, extensionContext) ? 1 : 0) != 0, (String)this.getZeroContextsProvidedErrorMessage(provider));
    }

    private List<P> validateProviders(ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        List<Extension> providers = extensionRegistry.stream(this.providerType).filter(provider -> this.supports(provider, extensionContext)).toList();
        return (List)Preconditions.notEmpty(providers, this::getNoRegisteredProviderErrorMessage);
    }

    private Optional<TestDescriptor> createInvocationTestDescriptor(C invocationContext, int index) {
        UniqueId invocationUniqueId = this.createInvocationUniqueId(this.parent.getUniqueId(), index);
        if (this.dynamicDescendantFilter.test(invocationUniqueId, index - 1)) {
            return Optional.of(this.createInvocationTestDescriptor(invocationUniqueId, invocationContext, index));
        }
        return Optional.empty();
    }

    private void execute(Node.DynamicTestExecutor dynamicTestExecutor, TestDescriptor testDescriptor) {
        testDescriptor.setParent(this.parent);
        dynamicTestExecutor.execute(testDescriptor);
    }

    abstract boolean supports(P var1, ExtensionContext var2);

    protected abstract String getNoRegisteredProviderErrorMessage();

    abstract Stream<? extends C> provideContexts(P var1, ExtensionContext var2);

    abstract boolean mayReturnZeroContexts(P var1, ExtensionContext var2);

    protected abstract String getZeroContextsProvidedErrorMessage(P var1);

    abstract UniqueId createInvocationUniqueId(UniqueId var1, int var2);

    abstract TestDescriptor createInvocationTestDescriptor(UniqueId var1, C var2, int var3);
}

