/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.mi.service.command.MIControlDMContext;
import org.eclipse.cdt.dsf.mi.service.command.commands.Adjustable;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class MICommand<V extends MIInfo>
implements ICommand<V> {
    private static final String[] empty = new String[0];
    List<Adjustable> fOptions = new ArrayList<Adjustable>();
    List<Adjustable> fParameters = new ArrayList<Adjustable>();
    String fOperation = "";
    Function<String, Adjustable> fParamToAdjustable;
    IDMContext fCtx;

    public MICommand(IDMContext ctx, String operation) {
        this(ctx, operation, empty, empty);
    }

    public MICommand(IDMContext ctx, String operation, String[] params) {
        this(ctx, operation, empty, params);
    }

    public MICommand(IDMContext ctx, String operation, String[] options, String[] params) {
        this(ctx, operation, options, params, null);
    }

    public MICommand(IDMContext ctx, String operation, String[] options, String[] params, Function<String, Adjustable> paramToAdjustable) {
        assert (ctx != null && DMContexts.getAncestorOfType((IDMContext)ctx, MIControlDMContext.class) != null);
        this.fCtx = ctx;
        this.fOperation = operation;
        this.fOptions = this.optionsToAdjustables(options);
        this.fParamToAdjustable = paramToAdjustable == null ? x -> new MIStandardParameterAdjustable((String)x) : paramToAdjustable;
        this.fParameters = this.parametersToAdjustables(params);
    }

    private final List<Adjustable> optionsToAdjustables(String[] options) {
        ArrayList<Adjustable> result = new ArrayList<Adjustable>();
        if (options != null) {
            String[] stringArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                result.add(new MIStandardOptionAdjustable(option));
                ++n2;
            }
        }
        return result;
    }

    private final List<Adjustable> parametersToAdjustables(String[] parameters) {
        return parameters != null ? Arrays.stream(parameters).map(this.fParamToAdjustable).collect(Collectors.toList()) : Collections.emptyList();
    }

    public String getCommandControlFilter() {
        MIControlDMContext controlDmc = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)this.getContext(), MIControlDMContext.class);
        return controlDmc.getCommandControlFilter();
    }

    public String getOperation() {
        return this.fOperation;
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        for (Adjustable option : this.fOptions) {
            result.add(option.getValue());
        }
        return result.toArray(new String[this.fOptions.size()]);
    }

    public void setOptions(String[] options) {
        this.fOptions = this.optionsToAdjustables(options);
    }

    public String[] getParameters() {
        ArrayList<String> result = new ArrayList<String>();
        for (Adjustable parameter : this.fParameters) {
            result.add(parameter.getValue());
        }
        return result.toArray(new String[this.fParameters.size()]);
    }

    public void setParameters(String[] params) {
        this.fParameters = this.parametersToAdjustables(params);
    }

    public void setParameters(Adjustable ... params) {
        this.fParameters = Arrays.asList(params);
    }

    public String constructCommand() {
        return this.constructCommand(null, -1);
    }

    public String constructCommand(String threadId, int frameId) {
        return this.constructCommand(null, threadId, frameId);
    }

    public String constructCommand(String groupId, String threadId, int frameId) {
        String p;
        String opt;
        StringBuilder command = new StringBuilder(this.getOperation());
        if (this.supportsThreadAndFrameOptions() && threadId != null && !threadId.trim().isEmpty()) {
            command.append(" --thread ").append(threadId);
            if (frameId >= 0) {
                command.append(" --frame ").append(frameId);
            }
        } else if (this.supportsThreadGroupOption() && groupId != null && !groupId.trim().isEmpty()) {
            command.append(" --thread-group ").append(groupId);
        }
        if (!(opt = this.optionsToString()).isEmpty()) {
            command.append(' ').append(opt);
        }
        if (!(p = this.parametersToString()).isEmpty()) {
            command.append(' ').append(p);
        }
        command.append('\n');
        return command.toString();
    }

    public ICommand<? extends ICommandResult> coalesceWith(ICommand<? extends ICommandResult> command) {
        return null;
    }

    public IDMContext getContext() {
        return this.fCtx;
    }

    public MIInfo getResult(MIOutput MIresult) {
        return new MIInfo(MIresult);
    }

    protected String optionsToString() {
        StringBuilder sb = new StringBuilder();
        if (this.fOptions != null && !this.fOptions.isEmpty()) {
            for (Adjustable option : this.fOptions) {
                sb.append(option.getAdjustedValue());
            }
        }
        return sb.toString().trim();
    }

    protected String parametersToString() {
        String[] options = this.getOptions();
        StringBuilder buffer = new StringBuilder();
        if (this.fParameters != null && !this.fParameters.isEmpty()) {
            if (options != null && options.length > 0) {
                for (Adjustable parameter : this.fParameters) {
                    if (!parameter.getValue().startsWith("-")) continue;
                    buffer.append('-').append('-');
                    break;
                }
            }
            for (Adjustable parameter : this.fParameters) {
                buffer.append(' ').append(parameter.getAdjustedValue());
            }
        }
        return buffer.toString().trim();
    }

    protected static boolean containsWhitespace(String s) {
        int i = 0;
        while (i < s.length()) {
            if (Character.isWhitespace(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean supportsThreadAndFrameOptions() {
        return true;
    }

    public boolean supportsThreadGroupOption() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MICommand) {
            MICommand otherCmd = (MICommand)obj;
            return (this.fCtx == null && otherCmd.fCtx == null || this.fCtx != null && this.fCtx.equals(otherCmd.fCtx)) && this.constructCommand().equals(otherCmd.constructCommand());
        }
        return false;
    }

    public int hashCode() {
        return this.constructCommand().hashCode();
    }

    public String toString() {
        return this.constructCommand();
    }

    public static abstract class MICommandAdjustable
    implements Adjustable {
        protected final String value;

        public MICommandAdjustable(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static class MINoChangeAdjustable
    extends MICommandAdjustable {
        public MINoChangeAdjustable(String param) {
            super(param);
        }

        @Override
        public String getAdjustedValue() {
            return this.getValue();
        }
    }

    public static class MIStandardOptionAdjustable
    extends MICommandAdjustable {
        public MIStandardOptionAdjustable(String option) {
            super(option);
        }

        @Override
        public String getAdjustedValue() {
            StringBuilder builder = new StringBuilder();
            String option = this.value;
            if (option.indexOf(34) != -1 || option.indexOf(92) != -1) {
                StringBuilder buf = new StringBuilder();
                int j = 0;
                while (j < option.length()) {
                    char c = option.charAt(j);
                    if (c == '\"' || c == '\\') {
                        buf.append('\\');
                    }
                    buf.append(c);
                    ++j;
                }
                option = buf.toString();
            }
            if (option.indexOf(9) != -1 || option.indexOf(32) != -1) {
                builder.append(' ').append('\"').append(option).append('\"');
            } else {
                builder.append(' ').append(option);
            }
            return builder.toString();
        }
    }

    public static class MIStandardParameterAdjustable
    extends MICommandAdjustable {
        public MIStandardParameterAdjustable(String parameter) {
            super(parameter);
        }

        @Override
        public String getAdjustedValue() {
            StringBuilder builder = new StringBuilder();
            int j = 0;
            while (j < this.value.length()) {
                char c = this.value.charAt(j);
                if (c == '\"' || c == '\\') {
                    builder.append('\\');
                }
                builder.append(c);
                ++j;
            }
            if (MICommand.containsWhitespace(this.value)) {
                builder.insert(0, '\"');
                builder.append('\"');
            }
            return builder.toString();
        }
    }
}

