/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.filewizard;

import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewFileWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.filewizard.WizardNewFileFromTemplateCreationPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewFileFromTemplateWizard
extends BasicNewResourceWizard {
    private WizardNewFileCreationPage mainPage;

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewFileFromTemplateCreationPage("newFilePage1", this.getSelection());
        this.mainPage.setTitle(NewFileWizardMessages.NewFileFromTemplateWizard_pageTitle);
        this.mainPage.setDescription(NewFileWizardMessages.NewFileFromTemplateWizard_description);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(NewFileWizardMessages.NewFileFromTemplateWizard_shellTitle);
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = CPluginImages.DESC_WIZBAN_NEW_FILE;
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException e) {
            NewFileFromTemplateWizard.openError(this.getShell(), NewFileWizardMessages.NewFileFromTemplateWizard_errorMessage, e.getMessage(), e);
        }
        return true;
    }

    public static void openError(Shell parent, String title, String message, PartInitException exception) {
        CoreException nestedException = null;
        IStatus status = exception.getStatus();
        if (status != null && status.getException() instanceof CoreException) {
            nestedException = (CoreException)status.getException();
        }
        if (nestedException != null) {
            ErrorDialog.openError((Shell)parent, (String)title, (String)message, (IStatus)nestedException.getStatus());
        } else {
            MessageDialog.openError((Shell)parent, (String)title, (String)message);
        }
    }
}

