/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.concurrent.Executor;
import org.eclipse.net4j.internal.util.bundle.OM;

public class DelayingExecutor
implements Executor,
Runnable {
    private final long delay;
    private Work scheduledWork;
    private boolean running;

    public DelayingExecutor(long delay) {
        this.delay = delay;
    }

    @Override
    public void execute(Runnable runnable) {
        this.scheduleWork(new Work(runnable));
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.running = true;
        try {
            block12: {
                Work currentWork;
                Thread thread;
                block11: {
                    thread = Thread.currentThread();
                    currentWork = null;
                    if (!true) break block11;
                    if (!this.running) return;
                    if (!thread.isAlive()) return;
                    if (thread.isInterrupted()) break block12;
                }
                do {
                    Work scheduledWork;
                    if ((scheduledWork = this.unscheduleWork()) != null) {
                        currentWork = scheduledWork;
                    }
                    long now = System.currentTimeMillis();
                    long sleepMillis = this.delay;
                    if (currentWork != null) {
                        long passedMillis = now - currentWork.scheduled;
                        if (passedMillis >= this.delay) {
                            this.doExecute(currentWork);
                            currentWork = null;
                        } else {
                            sleepMillis = this.delay - passedMillis;
                        }
                    }
                    try {
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                    if (!this.running) return;
                    if (!thread.isAlive()) return;
                } while (!thread.isInterrupted());
            }
            return;
        }
        finally {
            this.running = false;
        }
    }

    public void stop() {
        this.running = false;
    }

    protected void doExecute(Runnable runnable) {
        runnable.run();
    }

    private synchronized void scheduleWork(Work work) {
        this.scheduledWork = work;
        this.notifyAll();
    }

    private synchronized Work unscheduleWork() {
        Work w = this.scheduledWork;
        this.scheduledWork = null;
        return w;
    }

    private static final class Work
    implements Runnable {
        private final long scheduled = System.currentTimeMillis();
        private final Runnable runnable;

        public Work(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception ex) {
                OM.LOG.error(ex);
            }
        }
    }
}

