/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Tree
implements Comparable<Tree> {
    public static final Tree EMPTY = new Tree(null, null, null);
    private static final String DEFAULT_CHILD_NAME = "property";
    private static final String DEFAULT_NAME_ATTRIBUTE = "name";
    private static final String DEFAULT_VALUE_ATTRIBUTE = "value";
    private final String name;
    private final Map<String, String> attributes;
    private final Tree parent;
    private List<Tree> children;

    private Tree(String name, Map<String, String> attributes, Tree parent) {
        this.name = name;
        this.attributes = ObjectUtil.isEmpty(attributes) ? Collections.emptyMap() : Collections.unmodifiableMap(attributes);
        this.parent = parent;
    }

    private void setChildren(List<Tree> children) {
        this.children = ObjectUtil.isEmpty(children) ? Collections.emptyList() : Collections.unmodifiableList(children);
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String attribute(String name) {
        return this.attributes.get(name);
    }

    public String attribute(String name, String defaultValue) {
        String value = this.attribute(name);
        return value == null ? defaultValue : value;
    }

    public boolean attribute(String name, boolean defaultValue) {
        String value = this.attribute(name);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public byte attribute(String name, byte defaultValue) {
        String value = this.attribute(name);
        return value == null ? defaultValue : Byte.parseByte(value);
    }

    public short attribute(String name, short defaultValue) {
        String value = this.attribute(name);
        return value == null ? defaultValue : Short.parseShort(value);
    }

    public int attribute(String name, int defaultValue) {
        String value = this.attribute(name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public long attribute(String name, long defaultValue) {
        String value = this.attribute(name);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public float attribute(String name, float defaultValue) {
        String value = this.attribute(name);
        return value == null ? defaultValue : Float.parseFloat(value);
    }

    public double attribute(String name, double defaultValue) {
        String value = this.attribute(name);
        return value == null ? defaultValue : Double.parseDouble(value);
    }

    public Tree parent() {
        return this.parent;
    }

    public List<Tree> children() {
        return this.children;
    }

    public void children(Consumer<Tree> consumer) {
        for (Tree child : this.children) {
            consumer.accept(child);
        }
    }

    public List<Tree> children(String name) {
        ArrayList<Tree> result = new ArrayList<Tree>();
        this.children(name, result::add);
        return result;
    }

    public void children(String name, Consumer<Tree> consumer) {
        for (Tree child : this.children) {
            if (!Objects.equals(child.name, name)) continue;
            consumer.accept(child);
        }
    }

    public List<Tree> allChildren() {
        ArrayList<Tree> result = new ArrayList<Tree>();
        this.allChildren(result::add);
        return result;
    }

    public void allChildren(Consumer<Tree> consumer) {
        for (Tree child : this.children) {
            consumer.accept(child);
            child.allChildren(this.name, consumer);
        }
    }

    public List<Tree> allChildren(String name) {
        ArrayList<Tree> result = new ArrayList<Tree>();
        this.allChildren(name, result::add);
        return result;
    }

    public void allChildren(String name, Consumer<Tree> consumer) {
        for (Tree child : this.children) {
            if (Objects.equals(child.name, name)) {
                consumer.accept(child);
            }
            child.allChildren(name, consumer);
        }
    }

    public Tree child(String name) {
        for (Tree child : this.children) {
            if (!Objects.equals(child.name, name)) continue;
            return child;
        }
        return null;
    }

    public Tree child(int index) {
        return this.children.get(index);
    }

    public int indexInParent() {
        if (this.parent == null) {
            return -1;
        }
        return this.parent.indexOfChild(this);
    }

    public int indexOfChild(Tree child) {
        if (this.children != null) {
            return this.children.indexOf(child);
        }
        return -1;
    }

    public Map<String, String> properties() {
        return this.properties(DEFAULT_CHILD_NAME);
    }

    public Map<String, String> properties(String childName) {
        return this.properties(childName, DEFAULT_NAME_ATTRIBUTE, DEFAULT_VALUE_ATTRIBUTE);
    }

    public Map<String, String> properties(String childName, String nameAttribute, String valueAttribute) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Tree child : this.children(childName)) {
            String name = child.attribute(nameAttribute);
            if (name == null) continue;
            String value = child.attribute(valueAttribute);
            properties.put(name, value);
        }
        return properties;
    }

    public <DATA> DATA visit(BiFunction<Tree, DATA, DATA> visitor, DATA data) {
        if ((data = visitor.apply(this, data)) != null) {
            for (Tree child : this.children) {
                if (child.visit(visitor, data) != null) continue;
                return null;
            }
        }
        return data;
    }

    @Override
    public int compareTo(Tree o) {
        return StringUtil.compare(this.name, o.name);
    }

    public String toString() {
        return "Tree[" + this.name + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Tree source) {
        Builder builder = Tree.builder().setName(source.name).setAttributes(source.attributes);
        source.children.forEach(child -> {
            Builder builder2 = builder.addChild(Tree.builder(child));
        });
        return builder;
    }

    /* synthetic */ Tree(String string, Map map, Tree tree, Tree tree2) {
        this(string, map, tree);
    }

    public static final class Builder
    implements Comparable<Builder> {
        private String name;
        private final Map<String, String> attributes = new HashMap<String, String>();
        private Builder parent;
        private final List<Builder> children = new ArrayList<Builder>();

        private Builder() {
        }

        public String name() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Map<String, String> attributes() {
            return Collections.unmodifiableMap(this.attributes);
        }

        public String attribute(String name) {
            return this.attributes.get(name);
        }

        public Builder setAttribute(String name, String value) {
            if (value != null) {
                this.attributes.put(name, value);
            } else {
                this.attributes.remove(name);
            }
            return this;
        }

        public Builder setAttributes(Map<String, String> attributes) {
            this.attributes.clear();
            return this.addAttributes(attributes);
        }

        public Builder addAttributes(Map<String, String> attributes) {
            this.attributes.putAll(attributes);
            return this;
        }

        public Builder unsetAttribute(String name) {
            return this.setAttribute(name, null);
        }

        public Builder unsetAttributes(Set<String> names) {
            names.forEach(this.attributes::remove);
            return this;
        }

        public Builder unsetAttributes() {
            this.attributes.clear();
            return this;
        }

        public Builder parent() {
            return this.parent;
        }

        public Builder setParent(Builder parent) {
            if (parent != this.parent) {
                if (this.parent != null) {
                    this.parent.inverseRemoveChild(this);
                }
                this.inverseSetParent(parent);
                if (this.parent != null) {
                    this.parent.inverseAddChild(this);
                }
            }
            return this;
        }

        public List<Builder> children() {
            return Collections.unmodifiableList(this.children);
        }

        public void children(Consumer<Builder> consumer) {
            for (Builder child : this.children) {
                consumer.accept(child);
            }
        }

        public List<Builder> children(String name) {
            ArrayList<Builder> result = new ArrayList<Builder>();
            this.children(name, result::add);
            return result;
        }

        public void children(String name, Consumer<Builder> consumer) {
            for (Builder child : this.children) {
                if (!Objects.equals(child.name, name)) continue;
                consumer.accept(child);
            }
        }

        public List<Builder> allChildren() {
            ArrayList<Builder> result = new ArrayList<Builder>();
            this.allChildren(result::add);
            return result;
        }

        public void allChildren(Consumer<Builder> consumer) {
            for (Builder child : this.children) {
                consumer.accept(child);
                child.allChildren(this.name, consumer);
            }
        }

        public List<Builder> allChildren(String name) {
            ArrayList<Builder> result = new ArrayList<Builder>();
            this.allChildren(name, result::add);
            return result;
        }

        public void allChildren(String name, Consumer<Builder> consumer) {
            for (Builder child : this.children) {
                if (Objects.equals(child.name, name)) {
                    consumer.accept(child);
                }
                child.allChildren(name, consumer);
            }
        }

        public Builder child(String name) {
            for (Builder child : this.children) {
                if (!Objects.equals(child.name, name)) continue;
                return child;
            }
            return null;
        }

        public Builder child(int index) {
            return this.children.get(index);
        }

        public Builder addChild(Consumer<Builder> childInitializer) {
            Builder child = Tree.builder();
            this.addChild(child);
            childInitializer.accept(child);
            return this;
        }

        public Builder addChild(Tree child) {
            return this.addChild(Tree.builder(child));
        }

        public Builder addChild(Builder child) {
            if (child.parent != this) {
                if (child.parent != null) {
                    child.parent.inverseRemoveChild(child);
                }
                child.inverseSetParent(this);
                this.inverseAddChild(child);
            }
            return this;
        }

        public Builder addChildren(Builder ... children) {
            Builder[] builderArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Builder child = builderArray[n2];
                this.addChild(child);
                ++n2;
            }
            return this;
        }

        public Builder removeChild(Builder child) {
            if (child.parent == this) {
                child.inverseSetParent(null);
                this.inverseRemoveChild(child);
            }
            return this;
        }

        public Builder removeChildren(Builder ... children) {
            Builder[] builderArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Builder child = builderArray[n2];
                this.removeChild(child);
                ++n2;
            }
            return this;
        }

        public int indexInParent() {
            if (this.parent == null) {
                return -1;
            }
            return this.parent.indexOfChild(this);
        }

        public int indexOfChild(Builder child) {
            return this.children.indexOf(child);
        }

        public Map<String, String> properties() {
            return this.properties(Tree.DEFAULT_CHILD_NAME);
        }

        public Map<String, String> properties(String childName) {
            return this.properties(childName, Tree.DEFAULT_NAME_ATTRIBUTE, Tree.DEFAULT_VALUE_ATTRIBUTE);
        }

        public Map<String, String> properties(String childName, String nameAttribute, String valueAttribute) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Builder child : this.children(childName)) {
                String name = child.attribute(nameAttribute);
                if (name == null) continue;
                String value = child.attribute(valueAttribute);
                properties.put(name, value);
            }
            return properties;
        }

        public <DATA> DATA visit(BiFunction<Builder, DATA, DATA> visitor, DATA data) {
            if ((data = visitor.apply(this, data)) != null) {
                for (Builder child : this.children) {
                    if (child.visit(visitor, data) != null) continue;
                    return null;
                }
            }
            return data;
        }

        @Override
        public int compareTo(Builder o) {
            return StringUtil.compare(this.name, o.name);
        }

        public String toString() {
            return "Tree.Builder[" + this.name + "]";
        }

        public Tree build() {
            return this.build(null);
        }

        private Tree build(Tree parent) {
            Tree tree = new Tree(this.name, this.attributes, parent, null);
            if (this.children.isEmpty()) {
                tree.setChildren(Collections.emptyList());
            } else {
                ArrayList<Tree> childTrees = new ArrayList<Tree>();
                for (Builder child : this.children) {
                    Tree childTree = child.build(tree);
                    childTrees.add(childTree);
                }
                tree.setChildren(childTrees);
            }
            return tree;
        }

        private void inverseSetParent(Builder parent) {
            this.parent = parent;
        }

        private void inverseAddChild(Builder child) {
            if (!this.children.contains(child)) {
                this.children.add(child);
            }
        }

        private void inverseRemoveChild(Builder child) {
            this.children.remove(child);
        }
    }

    public static class Dumper
    implements BiFunction<Tree, String, String> {
        private final PrintStream out;

        public Dumper(PrintStream out) {
            this.out = out;
        }

        public Dumper() {
            this(System.out);
        }

        public final PrintStream out() {
            return this.out;
        }

        @Override
        public String apply(Tree tree, String indent) {
            indent = StringUtil.safe(indent);
            String name = StringUtil.safe(tree.name());
            StringBuilder builder = new StringBuilder();
            tree.attributes().forEach((n, v) -> {
                StringUtil.appendSeparator(builder, ", ");
                builder.append((String)n);
                builder.append('=');
                builder.append((String)v);
            });
            builder.insert(0, '[');
            builder.insert(0, name);
            builder.insert(0, indent);
            builder.append(']');
            this.out.println(builder);
            return this.nextLevelIndent(tree, indent);
        }

        protected String nextLevelIndent(Tree tree, String indent) {
            return String.valueOf(indent) + "  ";
        }

        public static String toString(Tree tree) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            tree.visit(new Dumper(new PrintStream(baos)), "");
            try {
                return baos.toString(StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException ex) {
                throw WrappedException.wrap(ex);
            }
        }
    }

    public static class XMLConverter
    implements BiFunction<Tree, Element, Element> {
        private final Document document;

        public XMLConverter(Document document) {
            this.document = document;
        }

        public XMLConverter(DocumentBuilder documentBuilder) {
            this(documentBuilder.newDocument());
        }

        public XMLConverter(DocumentBuilderFactory documentBuilderFactory) throws ParserConfigurationException {
            this(documentBuilderFactory.newDocumentBuilder());
        }

        public XMLConverter() throws ParserConfigurationException {
            this(DocumentBuilderFactory.newInstance());
        }

        public final Document document() {
            return this.document;
        }

        @Override
        public Element apply(Tree tree, Element parentElement) {
            Element element = this.createElement(tree);
            tree.attributes().forEach((n, v) -> this.setAttribute(tree, element, (String)n, (String)v));
            this.appendElement(tree, element, parentElement);
            return element;
        }

        protected Element createElement(Tree tree) {
            String tagName = this.getTagName(tree);
            return this.document.createElement(tagName);
        }

        protected void appendElement(Tree tree, Element element, Element parentElement) {
            if (parentElement == null) {
                this.document.appendChild(element);
            } else {
                parentElement.appendChild(element);
            }
        }

        protected void setAttribute(Tree tree, Element element, String name, String value) {
            element.setAttribute(name, value);
        }

        protected String getTagName(Tree tree) {
            return StringUtil.safe(tree.name(), "element");
        }

        public static Document convertTreeToDocument(Tree tree) throws ParserConfigurationException {
            XMLConverter converter = new XMLConverter();
            tree.visit(converter, null);
            return converter.document();
        }

        public static Element convertTreeToElement(Tree tree) throws ParserConfigurationException {
            Document document = XMLConverter.convertTreeToDocument(tree);
            return document.getDocumentElement();
        }

        public static Tree convertDocumentToTree(Document document) {
            return XMLConverter.convertDocumentToTree(document, null);
        }

        public static Tree convertDocumentToTree(Document document, Map<String, String> parameters) {
            Element element = document.getDocumentElement();
            return XMLConverter.convertElementToTree(element, parameters);
        }

        public static Tree convertElementToTree(Element element) {
            return XMLConverter.convertElementToTree(element, null);
        }

        public static Tree convertElementToTree(Element element, Map<String, String> parameters) {
            if (element == null) {
                return Tree.builder().build();
            }
            Builder builder = Tree.builder().setName(element.getTagName());
            NamedNodeMap attributes = element.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Node attrNode = attributes.item(i);
                if (attrNode.getNodeType() == 2) {
                    Attr attr = (Attr)attrNode;
                    String value = attr.getValue();
                    value = StringUtil.replace(value, parameters);
                    builder.setAttribute(attr.getName(), value);
                }
                ++i;
            }
            NodeList childNodes = element.getChildNodes();
            int i2 = 0;
            while (i2 < childNodes.getLength()) {
                Node childNode = childNodes.item(i2);
                if (childNode.getNodeType() == 1) {
                    Element childElement = (Element)childNode;
                    builder.addChild(XMLConverter.convertElementToTree(childElement, parameters));
                }
                ++i2;
            }
            return builder.build();
        }
    }
}

