/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.ui.internal.view.task.ProjectNode;
import org.eclipse.buildship.ui.internal.view.task.ProjectTask;
import org.eclipse.buildship.ui.internal.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.internal.view.task.TaskNode;
import org.eclipse.buildship.ui.internal.view.task.TaskSelector;
import org.eclipse.buildship.ui.internal.view.task.TaskSelectorNode;

public final class TaskGroupNode {
    private static final String DEFAULT_NAME = "other";
    private final List<TaskNode> taskNodes;
    private final ProjectNode projectNode;
    private final String name;

    private TaskGroupNode(ProjectNode projectNode, String name) {
        this.projectNode = (ProjectNode)Preconditions.checkNotNull((Object)projectNode);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.taskNodes = this.createTaskNodes(projectNode);
    }

    private List<TaskNode> createTaskNodes(ProjectNode projectNode) {
        ArrayList taskNodes = Lists.newArrayList();
        for (ProjectTask projectTask : this.getProjectTasks()) {
            taskNodes.add(new ProjectTaskNode(projectNode, projectTask));
        }
        for (TaskSelector taskSelector : this.getTaskSelectors()) {
            taskNodes.add(new TaskSelectorNode(projectNode, taskSelector));
        }
        return taskNodes;
    }

    private List<ProjectTask> getProjectTasks() {
        ArrayList projectTasks = Lists.newArrayList();
        for (ProjectTask projectTask : this.getProjectNode().getInvocations().getProjectTasks()) {
            if (!this.contains(projectTask)) continue;
            projectTasks.add(projectTask);
        }
        return projectTasks;
    }

    private List<TaskSelector> getTaskSelectors() {
        ArrayList taskSelectors = Lists.newArrayList();
        for (TaskSelector taskSelector : this.getProjectNode().getInvocations().getTaskSelectors()) {
            if (!this.contains(taskSelector)) continue;
            taskSelectors.add(taskSelector);
        }
        return taskSelectors;
    }

    public ProjectNode getProjectNode() {
        return this.projectNode;
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(ProjectTask projectTask) {
        return this.matches(projectTask.getGroup());
    }

    public boolean contains(TaskSelector taskSelector) {
        return this.matches(taskSelector.getGroup());
    }

    private boolean matches(String group) {
        return TaskGroupNode.normalizeGroupName(group).equals(this.name);
    }

    public List<TaskNode> getTaskNodes() {
        return this.taskNodes;
    }

    public String toString() {
        return "Task group '" + this.name + "'";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TaskGroupNode that = (TaskGroupNode)other;
        return Objects.equal((Object)this.projectNode, (Object)that.projectNode) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectNode, this.name});
    }

    public static TaskGroupNode getDefault(ProjectNode projectNode) {
        return new TaskGroupNode(projectNode, DEFAULT_NAME);
    }

    public static TaskGroupNode forName(ProjectNode projectNode, String groupName) {
        Preconditions.checkNotNull((Object)groupName);
        return new TaskGroupNode(projectNode, TaskGroupNode.normalizeGroupName(groupName));
    }

    private static String normalizeGroupName(String groupName) {
        return groupName.toLowerCase();
    }
}

