/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.codemining;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.genericeditor.target.extension.codemining.Messages;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.events.MouseEvent;

public class TargetDefinitionActivationCodeMining
extends LineHeaderCodeMining {
    private final IPath path;
    private final String error;

    public TargetDefinitionActivationCodeMining(int beforeLineNumber, IDocument document, ICodeMiningProvider provider, String error) throws BadLocationException {
        super(beforeLineNumber, document, provider);
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        String message = error;
        this.path = bufferManager.getTextFileBuffer(document).getLocation();
        if (this.path == null) {
            message = Messages.TargetDefinitionActivationCodeMining_e_location_outside_lfs;
        }
        this.error = message;
    }

    protected CompletableFuture<Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
        return CompletableFuture.runAsync(() -> {
            if (this.error != null) {
                this.setLabel(this.error);
                return;
            }
            boolean isCurrent = false;
            try {
                ITargetHandle workspaceTarget = this.acquireTargetPlatformService().getWorkspaceTargetHandle();
                if (workspaceTarget != null) {
                    isCurrent = Objects.equals(workspaceTarget.getMemento(), this.getTargetHandle().getMemento());
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            super.setLabel(isCurrent ? PDEUIMessages.AbstractTargetPage_reloadTarget : PDEUIMessages.AbstractTargetPage_setTarget);
        });
    }

    public Consumer<MouseEvent> getAction() {
        return t -> this.activateTargetPlatform();
    }

    private void activateTargetPlatform() {
        if (this.error != null) {
            return;
        }
        try {
            ITargetHandle targetHandle = this.getTargetHandle();
            ITargetDefinition toLoad = targetHandle.getTargetDefinition();
            LoadTargetDefinitionJob.load((ITargetDefinition)toLoad);
        }
        catch (CoreException e) {
            PDEPlugin.log((IStatus)e.getStatus());
        }
    }

    private ITargetHandle getTargetHandle() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile(this.path);
        if (!file.exists()) {
            file = root.getFileForLocation(this.path);
        }
        ITargetPlatformService service = this.acquireTargetPlatformService();
        ITargetHandle handle = file != null ? service.getTarget(file) : service.getTarget(URIUtil.toURI((IPath)this.path));
        return handle;
    }

    private ITargetPlatformService acquireTargetPlatformService() {
        return (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
    }
}

