/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassDeclarationKeywordContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;

public class ClassDeclarationKeywordsStrategy
extends AbstractCompletionStrategy {
    private static final String IMPLEMENTS_WITH_BLANK = " implements ";
    private static final String EXTENDS_WITH_BLANK = " extends ";
    private static final String IMPLEMENTS = "implements";
    private static final String EXTENDS = "extends";

    public ClassDeclarationKeywordsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ClassDeclarationKeywordsStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof ClassDeclarationKeywordContext)) {
            return;
        }
        ClassDeclarationKeywordContext concreteContext = (ClassDeclarationKeywordContext)context;
        ISourceRange replaceRange = this.getReplacementRange(concreteContext);
        String prefix = concreteContext.getPrefix();
        String statementText = concreteContext.getStatementText().toString();
        if (StringUtils.startsWithIgnoreCase((CharSequence)EXTENDS, (CharSequence)prefix) && statementText.indexOf(EXTENDS_WITH_BLANK) < 0) {
            reporter.reportKeyword(EXTENDS, this.getSuffix(concreteContext), replaceRange);
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)IMPLEMENTS, (CharSequence)prefix) && statementText.indexOf(IMPLEMENTS_WITH_BLANK) < 0) {
            reporter.reportKeyword(IMPLEMENTS, this.getSuffix(concreteContext), replaceRange);
        }
    }

    @Override
    public ISourceRange getReplacementRange(ICompletionContext context) throws BadLocationException {
        if (!this.isInsertMode()) {
            return this.getReplacementRangeWithSpaceAtPrefixEnd(context);
        }
        return super.getReplacementRange(context);
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        return this.isInsertMode() && abstractContext.hasSpaceAtPosition(this.getCompanion().getOffset()) ? "" : " ";
    }
}

