/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.ArrayList;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.ModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.core.ast.TclAdvancedExecuteExpression;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public final class TclPairMatcher
implements ICharacterPairMatcher {
    private final boolean DEBUG = false;
    private static final int MAX_PARSE_WAIT_TIME = 100;
    private static final int MIN_PARSE_INTERVAL = 2500;
    private final Object lock = new Object();
    private ParserThread thread = null;
    private long parsedAt = 0L;
    private IDocument fDocument;
    private int fAnchor;
    private PairBlock[] cachedPairs;
    private long cachedStamp = -1L;
    private long cachedHash = Long.MAX_VALUE;

    private static PairBlock[] computePairRanges(final String contents) {
        ArrayList result;
        block3: {
            ISourceParser pp = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.tcl.core.nature");
            ModuleDeclaration md = (ModuleDeclaration)pp.parse((IModuleSource)new ModuleSource(contents), null);
            if (md == null) {
                return new PairBlock[0];
            }
            result = new ArrayList();
            try {
                md.traverse(new ASTVisitor(){

                    public boolean visitGeneral(ASTNode be) throws Exception {
                        if (be instanceof StringLiteral) {
                            result.add(new PairBlock(be.sourceStart(), be.sourceEnd() - 1, '\"'));
                        } else if (be instanceof TclExecuteExpression) {
                            result.add(new PairBlock(be.sourceStart(), be.sourceEnd() - 1, '['));
                        } else if (be instanceof TclAdvancedExecuteExpression) {
                            result.add(new PairBlock(be.sourceStart() - 1, be.sourceEnd(), '['));
                        } else if (be instanceof Block) {
                            int start = be.sourceStart();
                            if (start != 0) {
                                result.add(new PairBlock(start, be.sourceEnd() - 1, '{'));
                            }
                        } else if (be instanceof TclBlockExpression) {
                            int start = be.sourceStart();
                            int end = be.sourceEnd();
                            if (start >= 0 && start < end && start < contents.length() && end <= contents.length() && contents.charAt(start) == '{' && contents.charAt(end - 1) == '}') {
                                result.add(new PairBlock(start, end - 1, '{'));
                            }
                        }
                        return super.visitGeneral(be);
                    }
                });
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        return result.toArray(new PairBlock[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalc(String content, long newTimestamp, long newHashcode) throws BadLocationException {
        ParserThread t;
        Object object = this.lock;
        synchronized (object) {
            if (this.thread != null) {
                return;
            }
            this.thread = t = new ParserThread(content, newTimestamp, newHashcode);
        }
        t.start();
        try {
            t.join(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePairs() throws BadLocationException {
        Object object = this.lock;
        synchronized (object) {
            if (System.currentTimeMillis() < this.parsedAt + 2500L) {
                return;
            }
        }
        if (this.fDocument instanceof IDocumentExtension4) {
            IDocumentExtension4 document = (IDocumentExtension4)this.fDocument;
            long newTimestamp = document.getModificationStamp();
            Object object2 = this.lock;
            synchronized (object2) {
                if (newTimestamp == this.cachedStamp) {
                    return;
                }
            }
            this.recalc(this.fDocument.get(), newTimestamp, Long.MAX_VALUE);
        } else {
            String content = this.fDocument.get();
            int newHashCode = content.hashCode();
            Object object3 = this.lock;
            synchronized (object3) {
                if ((long)newHashCode == this.cachedHash) {
                    return;
                }
            }
            this.recalc(content, -1L, newHashCode);
        }
    }

    private static boolean isBrace(char c) {
        return c == '{' || c == '}' || c == '\"' || c == '[' || c == ']';
    }

    private static boolean isBraceAt(IDocument document, int offset) throws BadLocationException {
        if (offset < document.getLength() && TclPairMatcher.isBrace(document.getChar(offset))) {
            return true;
        }
        return offset > 0 && TclPairMatcher.isBrace(document.getChar(offset - 1));
    }

    public IRegion match(IDocument document, int offset) {
        block5: {
            if (document == null || offset < 0) {
                throw new IllegalArgumentException();
            }
            try {
                this.fDocument = document;
                if (TclPairMatcher.isBraceAt(document, offset)) break block5;
                return null;
            }
            catch (BadLocationException e) {
                if (DLTKCore.DEBUG_PARSER) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        this.updatePairs();
        return this.matchPairsAt(offset);
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
    }

    public void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRegion matchPairsAt(int offset) {
        PairBlock[] pairs;
        Object object = this.lock;
        synchronized (object) {
            pairs = this.cachedPairs;
        }
        if (pairs == null) {
            return null;
        }
        int i = 0;
        int size = pairs.length;
        while (i < size) {
            PairBlock block = pairs[i];
            if (offset == block.end + 1) {
                this.fAnchor = 1;
                return new Region(block.start, 1);
            }
            if (offset == block.start + 1) {
                this.fAnchor = 1;
                return new Region(block.end, 1);
            }
            ++i;
        }
        return null;
    }

    private static class PairBlock {
        int start;
        int end;
        char c;

        public PairBlock(int start, int end, char c) {
            this.start = start;
            this.end = end;
            this.c = c;
        }
    }

    private class ParserThread
    extends Thread {
        final String content;
        final long newTimestamp;
        final long newHashcode;
        final long startTime;

        public ParserThread(String content, long newTimestamp, long newHashcode) {
            super(ParserThread.class.getName());
            this.startTime = System.currentTimeMillis();
            this.content = content;
            this.newTimestamp = newTimestamp;
            this.newHashcode = newHashcode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                PairBlock[] pairs = TclPairMatcher.computePairRanges(this.content);
                Object object = TclPairMatcher.this.lock;
                synchronized (object) {
                    TclPairMatcher.this.cachedPairs = pairs;
                    TclPairMatcher.this.cachedHash = this.newHashcode;
                    TclPairMatcher.this.cachedStamp = this.newTimestamp;
                    TclPairMatcher.this.parsedAt = this.startTime;
                }
            }
            catch (Throwable throwable) {
                Object object = TclPairMatcher.this.lock;
                synchronized (object) {
                    TclPairMatcher.this.thread = null;
                }
                throw throwable;
            }
            Object object = TclPairMatcher.this.lock;
            synchronized (object) {
                TclPairMatcher.this.thread = null;
            }
        }
    }
}

