/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.launching;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.Predicate;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.AbstractInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.launching.model.InterpreterGeneratedContent;
import org.eclipse.dltk.launching.model.LaunchingModel;
import org.eclipse.dltk.launching.model.LaunchingModelFactory;
import org.eclipse.dltk.launching.model.util.GeneratedContentPredicate;
import org.eclipse.dltk.ruby.internal.launching.RubyInterpreterRunner;
import org.eclipse.dltk.ruby.launching.RubyLaunchingPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class RubyGenericInstall
extends AbstractInterpreterInstall {
    private BuiltinsHelper helper = new BuiltinsHelper();

    public RubyGenericInstall(IInterpreterInstallType type, String id) {
        super(type, id);
    }

    public IInterpreterRunner getInterpreterRunner(String mode) {
        IInterpreterRunner runner = super.getInterpreterRunner(mode);
        if (runner != null) {
            return runner;
        }
        if (mode.equals("run")) {
            return new RubyInterpreterRunner((IInterpreterInstall)this);
        }
        return null;
    }

    public String getNatureId() {
        return "org.eclipse.dltk.ruby.core.nature";
    }

    public String getBuiltinModuleContent(String name) {
        Map<String, String> sources = this.helper.getSources();
        return sources.get(name);
    }

    public long lastModified() {
        this.helper.getSources();
        return this.helper.lastModified;
    }

    public String[] getBuiltinModules() {
        Map<String, String> sources = this.helper.getSources();
        return sources.keySet().toArray(new String[sources.size()]);
    }

    public class BuiltinsHelper {
        private static final int CACHE_LIFETIME = 86400000;
        private static final String SCRIPT_NAME = "scripts/builtin.rb";
        private static final String PREFIX = "#### DLTK RUBY BUILTINS ####";
        private Map<String, String> sources;
        long lastModified;

        private List<String> generateLines() throws IOException, CoreException {
            ArrayList<String> lines;
            IDeployment deployment;
            block3: {
                IExecutionEnvironment exeEnv = RubyGenericInstall.this.getExecEnvironment();
                deployment = exeEnv.createDeployment();
                if (deployment == null) {
                    return null;
                }
                IPath builder = deployment.add(RubyLaunchingPlugin.getDefault().getBundle(), SCRIPT_NAME);
                lines = new ArrayList<String>();
                IFileHandle builderFile = deployment.getFile(builder);
                InterpreterConfig config = ScriptLaunchUtil.createInterpreterConfig((IExecutionEnvironment)exeEnv, (IFileHandle)builderFile, (IFileHandle)builderFile.getParent());
                config.removeEnvVar("RUBYOPT");
                final Process process = ScriptLaunchUtil.runScriptWithInterpreter((IExecutionEnvironment)exeEnv, (String)RubyGenericInstall.this.getInstallLocation().toOSString(), (InterpreterConfig)config);
                Thread readerThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        BufferedReader input = null;
                        try {
                            input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                            String line = null;
                            try {
                                while ((line = input.readLine()) != null) {
                                    lines.add(line);
                                }
                            }
                            catch (IOException e) {
                                if (DLTKCore.DEBUG) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        finally {
                            block13: {
                                if (input != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (IOException e) {
                                        if (!DLTKCore.DEBUG) break block13;
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                });
                try {
                    readerThread.start();
                    readerThread.join(10000L);
                }
                catch (InterruptedException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
            deployment.dispose();
            return lines;
        }

        private void parseLines(List<String> lines) {
            String fileName = null;
            StringBuffer sb = new StringBuffer();
            for (String line : lines) {
                int index = line.indexOf(PREFIX);
                if (index != -1) {
                    if (fileName != null) {
                        String old = this.sources.get(fileName);
                        if (old == null) {
                            this.sources.put(fileName, sb.toString());
                        } else {
                            this.sources.put(fileName, String.valueOf(old) + "\n\n" + sb.toString());
                        }
                        sb.setLength(0);
                    }
                    fileName = line.substring(index + PREFIX.length());
                    continue;
                }
                sb.append(line);
                sb.append("\n");
            }
        }

        public synchronized Map<String, String> getSources() {
            if (this.sources == null) {
                this.sources = new HashMap<String, String>();
                this.load();
            }
            return this.sources;
        }

        private void load() {
            InterpreterGeneratedContent content = (InterpreterGeneratedContent)LaunchingModel.getInstance().find((IInterpreterInstall)RubyGenericInstall.this, (Predicate)new GeneratedContentPredicate(SCRIPT_NAME));
            if (content != null && content.getValue() != null && content.getLastModified() != null && content.getInterpreterLastModified() != null && content.getInterpreterLastModified().getTime() == RubyGenericInstall.this.getInstallLocation().lastModified()) {
                if (content.getFetchedAt() != null && content.getFetchedAt().getTime() + 86400000L > System.currentTimeMillis()) {
                    this.parseLines((List<String>)content.getValue());
                    this.lastModified = content.getLastModified().getTime();
                    return;
                }
            } else {
                content = null;
            }
            try {
                List<String> lines = this.generateLines();
                if (lines != null) {
                    this.parseLines(lines);
                    if (content != null) {
                        content = (InterpreterGeneratedContent)EcoreUtil.copy((EObject)content);
                        content.setFetchedAt(new Date());
                        if (!lines.equals(content.getValue())) {
                            content.getValue().clear();
                            content.getValue().addAll(lines);
                            content.setLastModified(content.getFetchedAt());
                        }
                    } else {
                        content = LaunchingModelFactory.eINSTANCE.createInterpreterGeneratedContent();
                        content.setKey(SCRIPT_NAME);
                        content.setFetchedAt(new Date());
                        content.setLastModified(content.getFetchedAt());
                        content.getValue().clear();
                        content.getValue().addAll(lines);
                        content.setInterpreterLastModified(new Date(RubyGenericInstall.this.getInstallLocation().lastModified()));
                    }
                    LaunchingModel.getInstance().save((IInterpreterInstall)RubyGenericInstall.this, (Predicate)new GeneratedContentPredicate(SCRIPT_NAME), (EObject)content);
                    this.lastModified = content.getLastModified().getTime();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

