/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.launching.sourcelookup.containers.BuildpathContainerSourceContainer;
import org.eclipse.dltk.launching.sourcelookup.containers.ScriptProjectSourceContainer;

public class ScriptSourceLookupUtil {
    public static ISourceContainer[] translate(IRuntimeBuildpathEntry[] entries) {
        ArrayList<ISourceContainer> containers = new ArrayList<ISourceContainer>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IRuntimeBuildpathEntry entry = entries[i];
            ISourceContainer container = null;
            switch (entry.getType()) {
                case 1: {
                    container = ScriptSourceLookupUtil.createProjectContainer(entry);
                    break;
                }
                case 2: {
                    container = ScriptSourceLookupUtil.createArchivePathContainer(entry);
                    break;
                }
                case 3: {
                    container = ScriptSourceLookupUtil.createBuildPathContainer(entry);
                    break;
                }
            }
            if (container != null) {
                containers.add(container);
            }
            ++i;
        }
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    private static ISourceContainer createArchivePathContainer(IRuntimeBuildpathEntry entry) {
        return new BuildpathContainerSourceContainer(entry.getLocation());
    }

    private static ISourceContainer createBuildPathContainer(IRuntimeBuildpathEntry entry) {
        IResource resource;
        Object container = null;
        String path = entry.getLocation();
        File file = new File(path);
        container = file.isDirectory() ? ((resource = entry.getResource()) instanceof IContainer ? new FolderSourceContainer((IContainer)resource, false) : new DirectorySourceContainer(file, false)) : new BuildpathContainerSourceContainer(path);
        return container;
    }

    private static ISourceContainer createProjectContainer(IRuntimeBuildpathEntry entry) {
        IResource resource = entry.getResource();
        ScriptProjectSourceContainer container = null;
        if (resource != null && resource.getType() == 4) {
            IScriptProject project = DLTKCore.create((IProject)((IProject)resource));
            if (project.exists()) {
                container = new ScriptProjectSourceContainer(project);
            } else if (resource.exists()) {
                container = new ProjectSourceContainer((IProject)resource, false);
            }
        }
        return container;
    }
}

