/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class EnumNLS {
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    private static final boolean DEBUG = false;
    static final int SEVERITY_ERROR = 4;
    static final int SEVERITY_WARNING = 2;

    private EnumNLS() {
    }

    private static Class<?> classOf(Enum<?>[] values) {
        Class<?> clazz = null;
        Enum<?>[] enumArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> value = enumArray[n2];
            if (clazz == null) {
                clazz = value.getClass();
            } else if (clazz != value.getClass()) {
                throw new IllegalArgumentException("Mix of different enums");
            }
            ++n2;
        }
        return clazz;
    }

    public static void initializeMessages(final Enum<?>[] values, final String fieldName) {
        final Class<?> clazz = EnumNLS.classOf(values);
        if (System.getSecurityManager() == null) {
            EnumNLS.load(clazz.getName(), clazz, values, fieldName);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                EnumNLS.load(clazz.getName(), clazz, values, fieldName);
                return null;
            }
        });
    }

    private static String[] buildVariants(String root) {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add(String.valueOf('_') + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = result.toArray(new String[result.size()]);
        }
        root = root.replace('.', '/');
        String[] variants = new String[nlSuffixes.length];
        int i = 0;
        while (i < variants.length) {
            variants[i] = String.valueOf(root) + nlSuffixes[i];
            ++i;
        }
        return variants;
    }

    private static void computeMissingMessages(String bundleName, Class<?> clazz, Field field, Map<String, Enum<?>> fieldMap, Enum<?>[] fieldArray) {
        int numFields = fieldArray.length;
        int i = 0;
        while (i < numFields) {
            Enum<?> item = fieldArray[i];
            if (fieldMap.get(item.name()) != Assigned.ASSIGNED) {
                try {
                    String value = "NLS missing message: " + item.name() + " in: " + bundleName;
                    EnumNLS.log(2, value, null);
                    field.set(item, value);
                }
                catch (Exception e) {
                    EnumNLS.log(4, "Error setting the missing message value for: " + field.getName(), e);
                }
            }
            ++i;
        }
    }

    static void load(String bundleName, Class<?> clazz, Enum<?>[] values, String fieldName) {
        boolean isAccessible;
        Field field;
        long start = System.currentTimeMillis();
        ClassLoader loader = clazz.getClassLoader();
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
        boolean bl = isAccessible = (field.getModifiers() & 1) != 0;
        if (!isAccessible) {
            field.setAccessible(true);
        }
        int len = values.length;
        HashMap fields = new HashMap(len * 2);
        int i = 0;
        while (i < len) {
            fields.put(values[i].name(), values[i]);
            ++i;
        }
        String[] variants = EnumNLS.buildVariants(bundleName);
        int i2 = 0;
        while (i2 < variants.length) {
            block20: {
                InputStream input;
                InputStream inputStream = input = loader == null ? ClassLoader.getSystemResourceAsStream(variants[i2]) : loader.getResourceAsStream(variants[i2]);
                if (input != null) {
                    try {
                        try {
                            MessagesProperties properties = new MessagesProperties(field, fields, bundleName);
                            properties.load(input);
                        }
                        catch (IOException e) {
                            EnumNLS.log(4, "Error loading " + variants[i2], e);
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ++i2;
        }
        EnumNLS.computeMissingMessages(bundleName, clazz, field, fields, values);
    }

    static void log(int severity, String message, Exception e) {
        String statusMsg;
        switch (severity) {
            case 4: {
                statusMsg = "Error: ";
                break;
            }
            default: {
                statusMsg = "Warning: ";
            }
        }
        if (message != null) {
            statusMsg = String.valueOf(statusMsg) + message;
        }
        if (e != null) {
            statusMsg = String.valueOf(statusMsg) + ": " + e.getMessage();
        }
        System.err.println(statusMsg);
        if (e != null) {
            e.printStackTrace();
        }
    }

    static enum Assigned {
        ASSIGNED;

    }

    private static class MessagesProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private final Field field;
        private final String bundleName;
        private final Map<String, Enum<?>> fields;

        public MessagesProperties(Field field, Map<String, Enum<?>> fieldMap, String bundleName) {
            this.field = field;
            this.fields = fieldMap;
            this.bundleName = bundleName;
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            Enum fieldObject = this.fields.put((String)key, Assigned.ASSIGNED);
            if (fieldObject == Assigned.ASSIGNED) {
                return null;
            }
            if (fieldObject == null) {
                String msg = "NLS unused message: " + key + " in: " + this.bundleName;
                EnumNLS.log(2, msg, null);
                return null;
            }
            try {
                this.field.set(fieldObject, new String(((String)value).toCharArray()));
            }
            catch (Exception e) {
                EnumNLS.log(4, "Exception setting field value.", e);
            }
            return null;
        }
    }
}

