/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text.rules;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.PatternRule;

public class RubySlashRegexpRule
extends PatternRule {
    private Comparator fLineDelimiterComparator = new DecreasingCharArrayLengthComparator();
    private char[][] fLineDelimiters;
    private char[][] fSortedLineDelimiters;

    public RubySlashRegexpRule(IToken token) {
        super("/", "/", token, '\\', true, false);
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        IToken token = super.evaluate(scanner, resume);
        if (token.isUndefined()) {
            return token;
        }
        this.processRegexpOptions(scanner);
        return token;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        block16: {
            originalDelimiters = scanner.getLegalLineDelimiters();
            count = originalDelimiters.length;
            if (this.fLineDelimiters != null && originalDelimiters.length == count) ** GOTO lbl7
            this.fSortedLineDelimiters = new char[count][];
            break block16;
lbl-1000:
            // 1 sources

            {
                --count;
lbl7:
                // 2 sources

                ** while (count > 0 && this.fLineDelimiters[count - 1] == originalDelimiters[count - 1])
            }
        }
        if (count != 0) {
            this.fLineDelimiters = originalDelimiters;
            System.arraycopy(this.fLineDelimiters, 0, this.fSortedLineDelimiters, 0, this.fLineDelimiters.length);
            Arrays.sort(this.fSortedLineDelimiters, this.fLineDelimiterComparator);
        }
        readCount = 1;
        block1: while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                if (this.fEscapeContinuesLine) {
                    c = scanner.read();
                    i = 0;
                    while (i < this.fSortedLineDelimiters.length) {
                        if (c != this.fSortedLineDelimiters[i][0] || !this.sequenceDetected(scanner, this.fSortedLineDelimiters[i], true)) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else {
                    scanner.read();
                }
            } else if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (this.sequenceDetected(scanner, this.fEndSequence, true)) {
                    return true;
                }
            } else if (this.fBreaksOnEOL) {
                i = 0;
                while (i < this.fSortedLineDelimiters.length) {
                    if (c == this.fSortedLineDelimiters[i][0] && this.sequenceDetected(scanner, this.fSortedLineDelimiters[i], true)) break block1;
                    ++i;
                }
            }
            ++readCount;
        }
        while (readCount > 0) {
            scanner.unread();
            --readCount;
        }
        return false;
    }

    private void processRegexpOptions(ICharacterScanner scanner) {
        int c;
        while ((c = scanner.read()) != -1) {
            if (!RubySyntaxUtils.isValidRegexpModifier((char)((char)c))) break;
        }
        scanner.unread();
    }

    private static class DecreasingCharArrayLengthComparator
    implements Comparator {
        private DecreasingCharArrayLengthComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((char[])o2).length - ((char[])o1).length;
        }
    }
}

