/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast.statements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;

public class SwitchStatement
extends Statement {
    private Expression fExpression;
    private ArrayList fStatements = new ArrayList();

    public SwitchStatement(DLTKToken switchToken, Expression exp) {
        super(switchToken.getColumn(), -1);
        this.fExpression = exp;
        if (this.fExpression != null) {
            this.setEnd(this.fExpression.sourceEnd());
        }
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Statement)this)) {
            if (this.fExpression != null) {
                this.fExpression.traverse(pVisitor);
            }
            if (this.fStatements != null) {
                Iterator i = this.fStatements.iterator();
                while (i.hasNext()) {
                    Statement statement = (Statement)i.next();
                    statement.traverse(pVisitor);
                }
            }
            pVisitor.endvisit((Statement)this);
        }
    }

    public int getKind() {
        return 2010;
    }

    public void acceptGroup(List l) {
        this.fStatements.addAll(l);
    }

    public Expression getExpression() {
        return this.fExpression;
    }

    public List getStatements() {
        return this.fStatements;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("switch:");
        if (this.fExpression != null) {
            this.fExpression.printNode(output);
        }
        if (this.fStatements != null) {
            output.indent();
            Iterator i = this.fStatements.iterator();
            while (i.hasNext()) {
                Statement statement = (Statement)i.next();
                statement.printNode(output);
                output.formatPrint("");
            }
            output.dedent();
        }
    }
}

